#ifndef RTC_MECHANISM_H
#define RTC_MECHANISM_H

#include "mbed.h"
#include "Model/Clock.h"
#include "Model/I_SetPresentTime.h"
#include "Model/I_SetMode.h"
#include "Model/OperationMode.h"
#include "Rtc8564/Rtc8564.h"

class RtcMechanism : public Model::I_SetPresentTime, public Model::I_SetMode
{
public:
    RtcMechanism();
    
    void setClock(Model::Clock* clock);
    void setRtc(Rtc8564* rtc);
    
    virtual void setPresentTime();
    virtual void mode(Model::OperationMode mode);
    void update();

private:
    Model::OperationMode m_mode;
    Model::Clock* m_clock;
    struct tm* m_dateTime;
    Rtc8564* m_rtc;
};

#endif // RTC_MECHANISM_H
