#include "mbed.h"
#include "I2cLCD/I2cLCD.h"
#include "Rtc8564/Rtc8564.h"
#include "ViewModel/ClockViewModel.h"
#include "Mechanism/RtcMechanism.h"
#include "Model/Clock.h"

extern "C" void HardFault_Handler()
{
    puts("Hard Fault!");
    while(1);
}

void no_memory ()
{
    puts("panic: can't allocate to memory!");
    exit(-1);
}

int main()
{
    set_new_handler(no_memory);

    DigitalOut led(LED1);
    I2C i2c(dp5, dp27); //sda scl
    I2cLCD lcd(i2c, dp26); //i2c reset
    Rtc8564 rtc(i2c, dp25, PullUp);
    ViewModel::ClockViewModel clockVm(lcd, dp28, dp24, dp17, dp1, dp2); // set increment decrement sound1 sound2
    RtcMechanism rtcMechanism;
    Model::Clock clock(&clockVm, &rtcMechanism);
    clock.addSetMode(&rtcMechanism);
    clock.addSetMode(&clockVm);
    rtcMechanism.setClock(&clock);
    rtcMechanism.setRtc(&rtc);
    clockVm.setClock(&clock);
    clock.initialize();
    clockVm.initialize();
    rtc.initialize();

    while(1) {
        led = 1;
        wait(0.5);
        led = 0;
        wait(0.5);
    }
}
