#ifndef CLOCK_VIEW_MODEL_H
#define CLOCK_VIEW_MODEL_H

#include "mbed.h"
#include "Model/Clock.h"
#include "I2cLCD/I2cLCD.h"
#include "Model/I_NotifyUpdate.h"
#include "DebouncedEdgeIn/DebouncedEdgeIn.h"
#include "beep.h"

namespace ViewModel
{
class ClockViewModel : public Model::I_NotifyUpdate, public Model::I_SetMode
{
public:
    ClockViewModel(I2cLCD& i2clcd, PinName set, PinName increment, PinName decrement, PinName sound1, PinName Sound2);
    void setClock(Model::Clock* clock);
    void initialize();

    virtual void dateTimeUpdated();
    virtual void mode(Model::OperationMode mode);

private:
    I2cLCD& m_i2clcd;
    DebouncedEdgeIn m_set;
    DebouncedEdgeIn m_increment;
    DebouncedEdgeIn m_decrement;
    Beep m_beep;
    DigitalOut m_beepGnd;
    Model::Clock* m_clock;
    struct tm* m_dateTime;
    Model::OperationMode m_mode;
    static const char* WEEKDAYS[];
        
    void modeButtonOn();
    void incrementButtonOn();
    void decrementButtonOn();
    void setCurSor();
};
}

#endif // CLOCK_VIEW_MODEL_H