#ifndef CLOCK_H
#define CLOCK_H

#include "mbed.h"
#include <vector>
#include "I_NotifyUpdate.h"
#include "I_SetPresentTime.h"
#include "I_SetMode.h"
#include "OperationMode.h"

namespace Model
{
class Clock
{
public:
    Clock(I_NotifyUpdate* notifyUpdate, I_SetPresentTime* setPresentTime);

    void addSetMode(I_SetMode* setMode);
    void initialize();
    void renew();
    struct tm* getDateTime();
    void requestModeChange();
    void requestIncrementValue();
    void requestDecrementValue();

private:
    I_NotifyUpdate* m_notifyUpdate;
    I_SetPresentTime* m_setPresentTime;
    struct tm m_dateTime;
    OperationMode m_mode;
    std::vector<I_SetMode*> m_setModes;
    
    void notifyMode();
    int getDays();
    void decideDayOfMonth();
    void decideDayOfWeek();
};
}

#endif // CLOCK_H