
#ifndef MBED_I2CLCD_H
#define MBED_I2CLCD_H

#include "mbed.h"

class I2cLCD : public Stream
{
public:

    enum IconType {
        Mark       =  0x0001,
        Battery_1  =  0x0004,
        Battery_2  =  0x0002,
        Battery_3  =  0x0010,
        Battery_4  =  0x0008,
        NoSound    =  0x0020,
        Lock       =  0x0040,
        ArrowDown  =  0x0080,
        ArrowUp    =  0x0100,
        Input      =  0x0200,
        Alarm      =  0x0400,
        Tell       =  0x0800,
        Antenna    =  0x1000,
    };

    I2cLCD(I2C& i2c, PinName rp);
#if DOXYGEN_ONLY
    int putc(int c);
    int printf(const char* format, ...);
#endif
    void locate(int column, int row);
    void cls();
    int rows();
    int columns();
    void seticon(IconType type);
    void clearicon(IconType type);
    void puticon(int flg);
    void cursor(bool isOn, int column, int row);

protected:
    virtual int _putc(int value);
    virtual int _getc();

    int address(int column, int row);
    void character(int column, int row, int c);
    void writeCommand( int cmd );
    void writeData( int data );

    DigitalOut _rs;
    I2C& _i2c;
    int _column;
    int _row;

    char contrast;
    int icon;

};

#endif