#ifndef DEBAUNCED_EDGE_IN_H
#define DEBAUNCED_EDGE_IN_H

#include "mbed.h"
#include "FunctionPointer.h"

class DebouncedEdgeIn
{
public:
    DebouncedEdgeIn(PinName in);
    virtual ~DebouncedEdgeIn();

    int read (void);
    operator int();

    /** Attach a function to call when a rising edge occurs on the input
     *
     *  @param fptr A pointer to a void function, or 0 to set as none
     */
    void rise(void (*fptr)(void));

    /** Attach a member function to call when a rising edge occurs on the input
     *
     *  @param tptr pointer to the object to call the member function on
     *  @param mptr pointer to the member function to be called
     */
    template<typename T>
    void rise(T* tptr, void (T::*mptr)(void)) {
        _rise.attach(tptr, mptr);
    }

    /** Attach a function to call when a falling edge occurs on the input
     *
     *  @param fptr A pointer to a void function, or 0 to set as none
     */
    void fall(void (*fptr)(void));

    /** Attach a member function to call when a falling edge occurs on the input
     *
     *  @param tptr pointer to the object to call the member function on
     *  @param mptr pointer to the member function to be called
     */
    template<typename T>
    void fall(T* tptr, void (T::*mptr)(void)) {
        _fall.attach(tptr, mptr);
    }

    /** Set the input pin mode
     *
     *  @param mode PullUp, PullDown, PullNone
     */
    void mode(PinMode pull);
    
private :
    // objects
    DigitalIn _in;
    Ticker _ticker;
    FunctionPointer _rise;
    FunctionPointer _fall;

    // function to take a sample, and update flags
    void _sample(void);

    // counters and flags
    int _samples;
    int _output;
    int _output_last;
};

#endif // DEBAUNCED_EDGE_IN_H
