#include "BlinkLed.h"

BlinkLed::BlinkLed(PinName pin, float dutyChangeStep) :
    led(pin),
    dutyChangeStep(dutyChangeStep),
    pause(true),
    thread(0)
{
}

BlinkLed::~BlinkLed()
{
}

void BlinkLed::startBlink()
{
    pause = false;
    if(!thread)
    {
        thread = new Thread(blink, this, osPriorityNormal, 128, NULL);
    }
    thread->signal_set(1);
}

void BlinkLed::finishBlink()
{
    pause = true;
}

bool BlinkLed::isBlinking()
{
    return !pause;
}

void BlinkLed::blink(void const *argument)
{
    BlinkLed* self = (BlinkLed*)argument;

    bool sign = false;
    while(1)
    {
        if(self->pause)
        {
            self->led = 0.0F;
            Thread::signal_wait(1);
        }
        float brightness = self->led;
        sign = (brightness <= 0.0F) ? true : (1.0F <= brightness) ? false : sign;
        self->led = sign ? brightness + self->dutyChangeStep : brightness - self->dutyChangeStep;
        Thread::wait(20);
    }
}
