/* Sample code for mbed eDISP Library
 * Copyright (c) 2010 todotani
 * Released under the MIT License: http://mbed.org/license/mit
 */

#include "mbed.h"
#include "eDisp.h"

// RGB color code table
int RGB_color[16] = {
    RGB_Navy,
    RGB_Silver,
    RGB_Blue,
    RGB_Maroon,
    RGB_Purple,
    RGB_Red,
    RGB_Fuchsia,
    RGB_Green,
    RGB_Teal,
    RGB_Lime,
    RGB_Aqua,
    RGB_Olive,
    RGB_Gray,
    RGB_Yellow,
    RGB_White,
    RGB_Black };

// RGB color name table
char* colorName[16] = {
    "Navy",
    "Silver",
    "Blue",
    "Maroon",
    "Purple",
    "Red",
    "Fuchsia",
    "Green",
    "Teal",
    "Lime",
    "Aqua",
    "Olive",
    "Gray",
    "Yellow",
    "White",
    "Black" };


eDisp display(p9, p10, 19200);     // tx, rx, baud

int main() {
    int i;

    wait(2);
    while (1) {
        // Test-1
        // clear graphics screen
        display.fillRect(0, 320, 240, 0, 0, RGB_Black); 
        display.reset();
        for (i = 0; i < 15; i++) {
            display.fillRect(0, 320, 16, 0, i*16, RGB_color[i]);
            display.locate(0, i);
            display.printf("%s", colorName[i] );
        }
        wait(2);

        // Test-2
        display.fillRect(0, 320, 240, 0, 0, RGB_Black);
        display.cls();
        for (i = 0; i < 15; i++) {
            display.drawLine(0, 1, i*16+1, 319, i*16+1, RGB_color[i]);
            display.drawLine(0, i*21+1, 0, i*21+1, 239, RGB_color[i]);
        }
        wait(2);

        // Test-3
        for (i = 0; i < 15; i++) {
            display.fillRect(0, 320, 240, 0, 0, RGB_color[i]);
            wait(0.2);      // wait until completion of draw
        }
        wait(2);
        
        // Test-4
        display.fillRect(0, 320, 240, 0, 0, RGB_Black);
        display.cls();
        for (i = 0; i < 15; i++) {
            display.textColor(RED + i%7);
            display.printf("漢字表示OK ＡAＢBＣC\n");
        }
        wait(2);
    }
}
