/* mbed eDISP Library
 * Copyright (c) 2010 todotani
 * Version 0.1 (March 6, 2010)
 * Released under the MIT License: http://mbed.org/license/mit
 */

#include "eDisp.h"
#include "error.h"

using namespace mbed;

eDisp::eDisp(PinName tx, PinName rx, int baud, int columns, int rows)
     :_serial(tx, rx), _columns(columns), _rows(rows) {
    _serial.baud(baud);
    cls();
}

int eDisp::_putc(int value) {
    if(value == '\n') {
        newline();
    } else {
        _serial.putc(value);
    }
    return value;
}

int eDisp::_getc() {
    return 0;
}

void eDisp::newline() {
    _column = 0;
    _row++;
    if (_row >= _rows) {
        _row = 0;
    }
    locate(_column, _row);
}

void eDisp::locate(int column, int row) {
    if (column < 0 || column >= _columns || row < 0 || row >= _rows) {
        error("locate(%d,%d) out of range on %dx%d display", column, row, _columns, _rows);
        return;
    }

    _row = row;
    _column = column;
    _serial.printf("\x1B[%d;%dH", _row, _column);
}

void eDisp::cls() {
    locate(0, 0);
    _serial.printf("\x1B[J");
}

void eDisp::reset() {
    _serial.printf("\x1B[m");
    cls();
}

void eDisp::textColor (int color) {
    _serial.printf("\x1B[%dm", color);
}

void eDisp::backgroundColor (int color) {
    _serial.printf("\x1B[%dm", color + 10);
}

void eDisp::fillRect (int buffer, int width, int hight, int x, int y, int color ) {
    _serial.printf("\x1B@0;%d;%d;%d;%d;%d;%dz", buffer, width, hight, x, y, color);
}

void eDisp::drawLine (int buffer, int x0, int y0, int x1, int y1, int color) {
    _serial.printf("\x1B@2;%d;%d;%d;%d;%d;%dz", buffer, x0, y0, x1, y1, color);
}
