#include "mbed.h"
#include "TextLCD.h"
#include "LinearTempSensor.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30, TextLCD::LCD16x2);  // RS, E, DB4, DB5, DB6, DB7
LinearTempSensor sensor(p20);                                 // With default parameters
//LinearTempSensor sensor(p20, 5, LinearTempSensor::MCP9700); // With option parameters

int main() 
{
    float Vout, Tav, To;

    lcd.cls();
    lcd.printf("TEMP:");
    
    while(true)
    {
        Vout = sensor.Sense();          // Sample data (read sensor)
        Tav  = sensor.GetAverageTemp(); // Calculate average temperature from N samples
        To   = sensor.GetLatestTemp();  // Calculate temperature from the latest sample

        lcd.locate(5, 0);
        lcd.printf("%4.1f", Tav);
        printf("Vout:%f  Tav:%f  To:%f\n\r", Vout, Tav, To);    // Debug print

        wait(2.0);
    }
}
