#include "UsbHostMgr.h"
//#define __DEBUG
#include "mydbg.h"

UsbDevice* UsbHostMgr::getDeviceByClass(uint8_t IfClass, int count)
{
    DBG("IfClass=%02X count=%d\n", IfClass, count);
    for(int i = 0; i < USB_HOSTMGR_MAX_DEVS; i++) {
       UsbDevice* dev = m_lpDevices[i];
       if (dev) {
           if(dev->m_connected && dev->m_enumerated) {
               if (dev->m_InterfaceClass == IfClass) { // found
                   if (count-- <= 0) {
                       return dev;
                   }
               }
           }
       }
    }
    return NULL;
}

void UsbHostMgr::onUsbDeviceConnected(int hub, int port)
{
  DBG("%p hub=%d port=%d\n", this, hub, port);
  for(int i = 0; i < USB_HOSTMGR_MAX_DEVS; i++) {
      UsbDevice* dev = m_lpDevices[i];
      if (dev) {
          if (dev->m_hub == hub && dev->m_port == port) { // skip
              return;
          }
      }
  }
  
  int item = devicesCount();
  DBG_ASSERT(item < USB_HOSTMGR_MAX_DEVS);
  if( item == USB_HOSTMGR_MAX_DEVS )
    return; //List full...
  //Find a free address (not optimized, but not really important)
  int addr = 1;
  for(int i = 0; i < item; i++)
  {
    DBG_ASSERT(m_lpDevices[i]);
    addr = MAX( addr, m_lpDevices[i]->m_addr + 1 );
  }
  DBG("item=%d addr=%d\n", item, addr);
  UsbDevice* dev = new UsbDevice( this, hub, port, addr );
  DBG_ASSERT(dev);
  dev->m_connected = true;
  m_lpDevices[item] = dev;
}
