#ifndef USB_ITD_H
#define USB_ITD_H
#include "UsbInc.h"
#include "usb_mem.h"

class usb_itd {
public:
    usb_itd(HCITD* itd);
    bool Done();
    int ConditionCode();
    int FrameCount();
    int PacketStatus(int n);
    int Length(int n);
    uint8_t* BufferPage(int n, int size);
    uint16_t StartingFrame();
    void free();
    void debug();
private:
    uint16_t get_psw(int n);
    HCITD* m_itd;
};

#endif //USB_ITD_H