#include "mbed.h"
#include "Usb_td.h"
//#define __DEBUG
#include "mydbg.h"

#define __TEST

#ifdef __TEST
#include <queue>
#endif

template class tdqueue<HCTD*>;
template class tdqueue<HCITD*>;

HCTD* td_reverse(HCTD* td)
{
    HCTD* result = NULL;
    HCTD* next;
    while(td) {
        next = (HCTD*)td->Next;
        td->Next = (uint32_t)result;
        result = td;
        td = next;
    }
    return result;
}

template <class T>
tdqueue<T>::tdqueue():m_head(NULL),m_tail(NULL)
{

}

template <class T>
int tdqueue<T>::size()
{
    int n = 0;
    T td = m_head;
    while(td) {
        td = (T)td->Next;
        n++;
    }
    return n;
}

template <class T>
bool tdqueue<T>::empty()
{
    return (m_head == NULL);
}

template <class T>
T tdqueue<T>::front()
{
    return m_head;
}

template <class T>
void tdqueue<T>::pop()
{
    T td = m_head;
    if (td) {
        m_head = (T)td->Next;
    }
    if (td == m_tail) {
        m_tail = NULL;
    }
}

template <class T>
void tdqueue<T>::push(T td)
{
    td->Next = NULL;
    if (m_tail) {
        m_tail->Next = (uint32_t)td;
    }
    m_tail = td;
    if (m_head == NULL) {
        m_head = td;
    }
}

#ifdef __TEST
static void test_td_list()
{
    tdqueue<HCTD*> list;
    HCTD* td1;
    HCTD* td2;
    HCTD* td3;
    HCTD* td4;
    // 0
    DBG_ASSERT(list.size() == 0);
    td1 = list.front();
    DBG_ASSERT(td1  == NULL);
    list.pop();
    td1 = list.front();
    DBG_ASSERT(td1 == NULL);
    // 1   
    td1 = (HCTD*)usb_get_td(1);
    list.push(td1);
    DBG_ASSERT(list.size() == 1);
    td2 = list.front();
    DBG_ASSERT(td2 == td1);
    list.pop();
    td2 = list.front();
    DBG_ASSERT(td2 == NULL);
    DBG_ASSERT(list.size() == 0);
    usb_free_td((byte*)td1);
    // 2
    td1 = (HCTD*)usb_get_td(1);
    td2 = (HCTD*)usb_get_td(2);
    list.push(td1);
    list.push(td2);
    DBG_ASSERT(list.size() == 2);
    td3 = list.front();
    DBG_ASSERT(td3 == td1);
    list.pop();
    td3 = list.front();
    DBG_ASSERT(td3 == td2);
    list.pop();
    td3 = list.front();
    DBG_ASSERT(td3 == NULL); 
    usb_free_td((byte*)td1);
    usb_free_td((byte*)td2);
    // 3 
    td1 = (HCTD*)usb_get_td(1);
    td2 = (HCTD*)usb_get_td(2);
    td3 = (HCTD*)usb_get_td(3);
    list.push(td1);
    list.push(td2);
    list.push(td3);
    DBG_ASSERT(list.size() == 3);
    td4 = list.front();
    DBG_ASSERT(td4 == td1);
    list.pop();
    td4 = list.front();
    DBG_ASSERT(td4 == td2);
    list.pop();
    td4 = list.front();
    DBG_ASSERT(td4 == td3);
    list.pop();
    td4 = list.front();
    DBG_ASSERT(td4 == NULL);    
    usb_free_td((byte*)td1);
    usb_free_td((byte*)td2);
    usb_free_td((byte*)td3);
    // n
    queue<HCTD*> queue;
    for(int n = 1; n <= 10; n++) {
        DBG_ASSERT(list.size() == queue.size());
        DBG_ASSERT(list.empty() == queue.empty());
        if (list.empty() || (rand()%10) > 5) {
            td1 = (HCTD*)usb_get_td(n);
            if (td1) {
                list.push(td1);
                queue.push(td1);
            }
            //DBG("+ %d %p\n", n, td1);
        } else {
            td1 = list.front();
            td2 = queue.front();
            if (td1 != td2) {
                //DBG("td1=%p td2=%p\n", td1, td2);
            }
            DBG_ASSERT(td1 == td2);
            if (td1) {
                list.pop();
                queue.pop();
                usb_free_td((byte*)td1);
            }
            //DBG("- %d %p\n", n, td1);
        }
    }
    while(!list.empty()) {
        td1 = list.front();
        list.pop();
        usb_free_td((byte*)td1);
    }
    //DBG_ASSERT(0);    
}

static void test_td_reverse()
{

    HCTD* td1;
    HCTD* td2;
    HCTD* td3;
    HCTD* td4;
    // 0
    td1 = NULL;
    td2 = td_reverse(td1);
    DBG_ASSERT(td2 == NULL);
    // 1
    td1 = (HCTD*)usb_get_td(1);
    DBG_ASSERT(td1);
    DBG_ASSERT(td1->Next == NULL);
    td2 = td_reverse(td1);
    DBG_ASSERT(td2 == td1);
    DBG_ASSERT(td2->Next == NULL);
    usb_free_td((byte*)td1);
    // 2
    td1 = (HCTD*)usb_get_td(1);
    DBG_ASSERT(td1);
    td2 = (HCTD*)usb_get_td(2);
    DBG_ASSERT(td2);
    td1->Next = (uint32_t)td2;
    td3 = td_reverse(td1);
    DBG_ASSERT(td3 == td2);
    DBG_ASSERT(td3->Next == (uint32_t)td1);
    DBG_ASSERT(td1->Next == NULL);
    usb_free_td((byte*)td1);
    usb_free_td((byte*)td2);
    // 3
    td1 = (HCTD*)usb_get_td(1);
    td2 = (HCTD*)usb_get_td(2);
    td3 = (HCTD*)usb_get_td(3);
    td1->Next = (uint32_t)td2;
    td2->Next = (uint32_t)td3;
    td4 = td_reverse(td1);
    DBG_ASSERT(td4 == td3);
    DBG_ASSERT(td3->Next == (uint32_t)td2);
    DBG_ASSERT(td2->Next == (uint32_t)td1);
    DBG_ASSERT(td1->Next == NULL);
    usb_free_td((byte*)td1);
    usb_free_td((byte*)td2);
    usb_free_td((byte*)td3);
}

void test_td()
{
    test_td_reverse();
    test_td_list();
    DBG("Usb_td.cpp TD test done.\n");
}
#else  //__TEST
void test_td()
{

}
#endif //__TEST