#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"
#include "ssl.h"


/* CyaSSL example client

This example uses a static IP Address of 192.168.2.4
Change that in the eth variable if yours is different

If you're using dhcp uncomment the dhcp line and comment out the static ip

This example assumes the SSL server is at 10.0.1.2 on port 11111
Change those in the main loop if yours is differnt

The example connects and then writes "secure hello from mbed" to server
Any repsonse will written to stdout

*/

//EthernetNetIf eth;   // dhcp

EthernetNetIf eth(
  IpAddr(192,168,2,4), //IP Address
  IpAddr(255,255,255,0), //Network Mask
  IpAddr(192,168,2,1), //Gateway
  IpAddr(192,168,2,1)  //DNS
);


TCPSocket sock;
SSL_CTX* ctx = 0;
SSL*     ssl = 0;
int      SSL_connected = 0;



int recvf(char* buf, int sz, void* vp)
{
    int got = sock.recv(buf, sz);
    
    if (got == 0)
        return -2;  // IO_ERR_WANT_READ;
    
    return got;
}


int sendf(char* buf, int sz, void* vp)
{

    int sent = sock.send(buf, sz);
    
    if (sent == 0)
        return -2;  // IO_ERR_WANT_WRITE
        
    return sent;
}


void err_str(const char* from, SSL* ssl)
{
    int  err;
    char str[80];
    
    printf("got error from %s\n", from);
    err = SSL_get_error(ssl, 0);
    if (err == SSL_ERROR_WANT_READ || err == SSL_ERROR_WANT_WRITE)
        printf("non-blocking IO couldn't complete, will continue when can\n");
    else
        printf("err = %d, %s\n", err, ERR_error_string(err, str));
}


void onTCPSocketEvent(TCPSocketEvent e)
{
    int err;
    char buffer[1024];
    
    switch (e) {
        case TCPSOCKET_CONNECTED :
            printf("we connected\n");

            ctx = SSL_CTX_new(TLSv1_client_method());
            
            if (ctx == 0) {
                printf("oops, bad SSL ctx\n");
                break;
            }
                
            SSL_CTX_set_verify(ctx, SSL_VERIFY_NONE, 0);
            
            CyaSSL_SetIORecv(ctx, recvf);
            CyaSSL_SetIOSend(ctx, sendf);
            
            
            ssl = SSL_new(ctx);
            
            if (ssl == 0) {
                printf("oops, bad SSL ptr\n");
                break;
            }
            
            CyaSSL_SetIOReadCtx(ssl, (void*)&sock);
            CyaSSL_SetIOWriteCtx(ssl, (void*)&sock);
            err = SSL_connect(ssl);
            
            if (err != SSL_SUCCESS) {
                err_str("SSL connect", ssl);
            }             
            break;
            
        case TCPSOCKET_READABLE :
            printf("we're readable\n");
            
            if (SSL_connected == 0) {
                err = SSL_connect(ssl);
                if (err < 0) {
                    err_str("SSL connect", ssl);
                }
                else {
                    const char msg[] = "secure hello from mbed\n";
                    SSL_connected = 1;
                    printf("we did SSL connect!\n");
                    err = SSL_write(ssl, msg, sizeof(msg));
                    if (err < 0) {
                        err_str("SSL wirte", ssl);
                    }
                }
            } else {
                err = SSL_read(ssl, buffer, sizeof(buffer));
                if (err < 0) {
                    err_str("SSL read", ssl);
                }
                else {
                    buffer[err] = 0;
                    printf("got message %s\n", buffer);
                }
            }  
            break;
            
        case TCPSOCKET_WRITEABLE :
        
            break;
       
        default:
            printf("default, case e = %d\n", e);
            break;
    }
}



int main() {
   
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("\r\nSetup OK\r\n");

    sock.setOnEvent(&onTCPSocketEvent);
    
    Host server(IpAddr(10,0,1,2), 11111);
    TCPSocketErr bindErr = sock.connect(server);
    
    printf("socket connect ret = %d\n", bindErr);
   
  
    while(1) {
       Net::poll();
    }
}