#include "ADNS5090.h"

ADNS5090::ADNS5090(PinName mosi_pin, PinName miso_pin, PinName sclk_pin, PinName ncs_pin, float pxPerMM_) :
    spi(mosi_pin, miso_pin, sclk_pin),
    ncs(ncs_pin),
    dx_px(0), dy_px(0),
    pxPerMM(pxPerMM_)
{
    ncs = 1;
    spi.format(8,3);
    spi.frequency(1000000);    
    reset();
}


bool ADNS5090::updateMotion()
{
    bool ret = false;    
    dx_px = 0;
    dy_px = 0;    
    
    ncs = 0;    
    spi.write(ADNS5090_MOTION_ST_REG);    
    
    if(0x80 & spi.write(0))
    {
        spi.write(ADNS5090_MOTION_BURST_REG);
        dx_px = (int8_t)spi.write(0);
        dy_px = (int8_t)spi.write(0);
        sq = (uint8_t)spi.write(0);
        ret = true;
    }
    ncs = 1;    
    return ret;
}

float ADNS5090::dx()
{
    return dx_px/pxPerMM;
}

float ADNS5090::dy()
{
    return dy_px/pxPerMM;
}

void ADNS5090::reset()
{
    ncs = 0;
    spi.write(ADNS5090_WRITE_VAL |
        ADNS5090_RESET_REG);
    spi.write(ADNS5090_RESET_VAL);
    ncs = 1;
}

void ADNS5090::powerDown()
{
    ncs = 0;
    spi.write(ADNS5090_WRITE_VAL |
        ADNS5090_MOUSE_CTRL_REG);
    spi.write(ADNS5090_POWERDOWN_VAL);
    ncs = 1;
}

void ADNS5090::setDPI()
{    
    ncs = 0;
    spi.write(ADNS5090_WRITE_VAL|
        ADNS5090_MOUSE_CTRL_REG);
    spi.write(0x24);
    ncs = 1;
    
    ncs = 0;
    spi.write(ADNS5090_WRITE_VAL|
        0x21);        
    spi.write(0x10);
    ncs = 1; 
}