#ifndef ACS712_H
#define ACS712_H

/****
    This class calculates the current drawn by the robot. It requires that EVERYTHING else is turned off when
    calibration is in progress.
    Requirement: Turn off mouse sensors somehow.
*/

#include "mbed.h"
//#include "robot.h"

#define HIGH_CURRENT 130       //increase of current when switch is turned on [mA]
#define LOW_CURRENT 36          //current draw when everything is turned off [mA]
#define SWITCH_PIN PTB18//HIGH_CURRENT_SWITCH
#define SENSOR_PIN PTC2//CURRENTSENSOR_PIN

#define CALIBRATION_SAMPLES 50 //the number of samples taken for the calibration

class ACS712
{
private:

    AnalogIn sensor;            //reads the value from current sensor
    DigitalOut currentSwitch;   //turn this on to send current through a resistor
    
    float b;        //offset
    float m;        //slope
    float current;  //[mA]
    float sensor_val;   //[% of 3.3V]
    
public:
    
    ACS712();
    void calibrate();          //calculates m and b
    float get_current();        //returns the current [mA]
    float read_sensor();        //reads sensor [% of 3.3V]
    float read_sensor(int n, int t);    //reads sensor <n> times and returns the average
};



#endif