#ifndef STATE_HPP
#define STATE_HPP

typedef void (*Void2Void)(void);

class State {
   Void2Void onStopToSwing;
   Void2Void onStopToMaybe;

   int currentState(int prevState, float pitch);

   public:
      static const int STOP = 0;
      static const int SWING = 1;
      static const int MAYBESTOP = 2;
      static const int SIT = 3;
      static const int UNCALIBRATED = 4;

      int state;

      State();

      void onSwing(Void2Void handler);
      void onMaybe(Void2Void handler);

      void next(float thigh);
};

#endif // STATE_HPP
