#ifndef PACEDETECTOR_HPP
#define PACEDETECTOR_HPP

#include "Smoother.hpp"

class PaceDetector {
   Smoother kneeSmoother;

   float smoothKnee;
   float lastSmoothKnee;

   float dSmoothKnee;
   float lastDSmoothKnee;
   int plusDSmoothKneeCount;

   float lastPeak;
   float currentPeak;

   bool peakDetected;

   bool atPeak();

   public:
      PaceDetector() :
         smoothKnee(0),
         lastSmoothKnee(0),
         dSmoothKnee(0),
         lastDSmoothKnee(0),
         plusDSmoothKneeCount(0),
         lastPeak(-1),
         currentPeak(-1),
         peakDetected(false) {}

      void process(float time, float thigh, float shin);

      float pace();

      void lookForPeak();
};

#endif // PACEDETECTOR_HPP

