#ifndef ACTUATOR_HPP
#define ACTUATOR_HPP

#include "spline.h"

class Actuator {
   tk::spline kneeDiffCurve;
   tk::spline hipCurve;
   float tHeelStrike;
   float T;

   static const float TMIN = 0.5;
   static const float TMAX = 3;
   static const float MIDSTANCE = 0.25;

   public:
      Actuator() : tHeelStrike(0), T(2) {}

      void setPeriod(float T);
      void startHeelStrike(float time);
      void startMidStance(float time);

      float getKneeDiff(float time);
      float getHip(float time);
};

#endif // ACTUATOR_HPP

