#ifndef DMP_H
#define DMP_H

#include "rtos.h"
#include "MPU6050_6Axis_MotionApps20.h"
#include "IMUDATA.h"
#include "robot.h"

#define PRINT_GYR     //uncomment this to print gyro data
//#define PRINT_ACC     //uncomment this to print accel data

#define PI 3.1415926

#define DMP_RESET_PIN           IMU_RESET_PIN
#define DMP_SDA_PIN             IMU_SDA_PIN
#define DMP_NOTUSED_PIN         IMU_NOTUSED_PIN
#define  MPU_LED_ON              LED_ON  
#define  MPU_LED_OFF             LED_OFF      

#define DMP_DBG_MSG(...)        //bt.printf(__VA_ARGS__);   //uncomment this to print debug messages

#define  RESET_BAUD_RATE        bt.baud(BT_BAUD_RATE);     
    
extern volatile bool mpuInterrupt; //indicates whether interrupt pin has gone high
extern uint16_t packetSize;    // expected DMP packet size (default is 42 bytes)
extern uint16_t fifoCount;     // count of all bytes currently in FIFO

int test_dmp();
int test_dmp2();
void start_dmp(MPU6050 mpu1);    //this will get the DMP ready
void start_dmp2(MPU6051 mpu1);    //this will get the DMP ready
void update_dmp();   //call this frequently
void update_dmp2();   //call this frequently
void update_yaw(MPU6050);   //this only updates yaw
void update_acc();   //this only updates the acceleration
void calibrate_1();
void calibrate_optFlow();


#endif