#ifndef SENSOR_HPP
#define SENSOR_HPP

#include "robot.h"

class Sensor {
   float thighOffset;
   float shinOffset;

   float thighRaw() { return imu_data.ypr[1]; }
   float shinRaw() { return imu2_data.ypr[1]; }

   public:
      Sensor() : thighOffset(0), shinOffset(0) {}
      void calibrate() {
         thighOffset = thighRaw();
         shinOffset = shinRaw();
      }
      float time() { return getTime(); }
      float thigh() { return imu_data.ypr[1] - thighOffset; }
      float shin() { return imu2_data.ypr[1] - shinOffset; }
};

#endif // SENSOR_HPP

