#include "PaceDetector.hpp"

void PaceDetector::process(float time, float thigh, float shin) {
   kneeSmoother.insert(time, shin-thigh);

   if(atPeak()) {
      lastPeak = currentPeak;
      currentPeak = time;
      peakDetected = true;
   }

   lastSmoothKnee = smoothKnee;
   smoothKnee = kneeSmoother.get();

   if(lastDSmoothKnee > 0) {
      plusDSmoothKneeCount += 1;
   } else {
      plusDSmoothKneeCount = 0;
   }
   lastDSmoothKnee = dSmoothKnee;
   dSmoothKnee = smoothKnee-lastSmoothKnee;
}

bool PaceDetector::atPeak() {
   return
      plusDSmoothKneeCount > 4 &&
      lastDSmoothKnee > 0 &&
      dSmoothKnee < 0 &&
      !peakDetected;
}

float PaceDetector::pace() {
   if(currentPeak != -1 && lastPeak != -1) {
      return currentPeak - lastPeak;
   } else {
      return 1.0;
   }
}

void PaceDetector::lookForPeak() {
   peakDetected = false;
}

