/* ========================================
 * Filename: globals.c
 *
 * Description: global variables and structures
 *
 * Copyright J-Factor Embedded Technologies 2015
 * Copyright TJM Embedded Software 2015
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF J-Factor Embedded Technologies.
 *
 * ========================================
*/
/** \file
 * \brief global variables needed by other files.
 */
//#include <project.h>
#include <time.h>
#include "common.h"

/* globals */
char* c_time_string;            //!< relatine time and date string
char time_string[10] = "00:00:00"; //!< relatine time only string
time_t epoch;                   //!< time in seconds since epoch
int32 iVref;                    //!< voltage across reference resistor
int32 iVtherm;                  //!<  Voltages across thermistor
uint32 iRes;                    //!< Resistance of Thermistor
int32 iTemp;                    //!< Temperature value (x 100) in degrees C
int32 iCurrent0;                //!< current in AMUX 0
int32 iCurrent1;                //!< current in AMUX 1
int32 iCurrent2;                //!< current in AMUX 2
int32 iCurrent3;                //!< current in AMUX 3
uint8 lampTestStatus;           //!< lamp test status
uint16 lampTestTime;            //!< running lamp test time
uint16 lampTestTimeSet;         //!< reset lamp test time
uint8 runStatus;                //!< 0 - not running control mode, 1 = running in control mode
uint8 pendantPresent;           //!< pendant present flag after lamp test
uint8 checkPendant;             //!< check pendant state inside lamp test
uint8 pendantTestStatus;        //!< pendant test status
uint16 pendantTestTime;         //!< running pendant test time
uint16 pendantTestTimeSet;      //!< reset pendant test time
uint8 phaseUV;                  //!< phase under voltage bit 0-AB, 1-AC, 2-BC
uint8 tempFailed;               //!< temperature above set point
uint8 v5Failed;                 //!< 5 volt failuer
uint8 v24Failed;                //!< 24 volt failuer
uint8 HVState;                  //!< high voltage state
uint32 HVStateMsg;              //!< high voltage state message flags
uint8 engHVSwitchStatus;        //!< HV engaged switch NO and NC
float ampsPerVolt;              //!< voltage to current translation
uint16 tempSampleRate;          //!< running temperature sample rate
uint16 oneSecond;               //!< running second timer
uint16 engagedSwitchTimeOn;     //!< running engaged switch time
uint16 engagedSwitchTimeOff;    //!< running engaged switch time
uint16 ignitionTestTime;        //!< running ignition test time
uint16 ignitionTestTimeSet;     //!< reset ignition test time
uint16 softStartTestTime;       //!< running soft start test time
uint16 softStartTestTimeSet;    //!< reset soft start test time
uint16 currentSampleTime;       //!< running current sample time
uint16 currentSampleTimeSet;    //!< reset current sample test time
uint16 currentStableTestTime;   //!< running current stable test time
uint16 currentStableTestTimeSet;//!< reset current stable test time
uint16 currentStartTestTime;    //!< running current start test time
uint16 currentStartTestTimeSet; //!< reset current start test time
uint16 currentMinTestTime;      //!< running current start test time
uint16 currentMinTestTimeSet;   //!< reset current start test time
uint16 currentRampRate;         //!< running current ramp rate
uint16 currentRampRateTerminate;//!< running current ramp rate for termination
uint16 currentRampRateFoldback; //!< running current ramp rate for foldback
uint16 currentRampRateEncoder;  //!< running current ramp rate for encoder
uint16 currentRampRateSet;      //!< reset current ramp rate
uint8 currentRampMode;          //!< current ramp direction
uint16 encoderSampleRate;       //!< running encoder sample rate
uint16 encoderSampleRateSet;    //!< reset encoder sample rate
uint16 bridgeOCFlagTime;        //!< bridge_oc_flag valid time
uint16 outputOCFlagTime;        //!< output_oc_flag valid time
uint16 utilOCFlagTime;          //!< util_oc_flag valid time
uint16 eStopTime;               //!< E_STOP valid time
uint8 eStopSeen;                //!< E_STOP seen
uint16 phaseABFlagTime;         //!< phase_ab_uv valid time
uint16 phaseBCFlagTime;         //!< phase_bc_uv valid time
uint16 phaseACFlagTime;         //!< phase_ac_uv valid time
uint16 contactorTestTime;       //!< output_oc_flag valid time
uint8 waitForPowerCycle;        //!< wait for power cycle after a failure
float analogTemp;               //!< analog temperature value
int16 encoderValue;             //!< last sampled encoder value
int16 encoderDiff;              //!< last sampled encoder value differnce from current
uint8 encoderChanged;           //!< encoder value changed since last sample
uint8 pendantFailed;            //!< pendant failure
uint16 flashCtrlSys;            //!< CTRL SYS flash rate
uint8 currentBelowMin;          //!< current below minimum in normal operation
uint8 outputOCSeen;             //!< output_oc_flag seen
uint8 lampTestInitFail;         //!< initla tests fail before lamptest
uint16 initFailType;            //!< initial test failure type
float currentStableMin;         //!< current stable min
float currentStableMax;         //!< current stable max
uint8 utilOCSeen;               //!< util_oc flag change seen
uint16 currentIndex;            //!< current source index
uint8 currentOffMaxIndex;       //!< current off max parameter index
uint8 tempSetIndex;             //!< temperature set index
uint16 bytesRead;

char *engagedState[] = {"HV Engaged Unknown", "HV Engaged On", "HV Engaged Off", "HV Engaged Unknown"};
char *autoState[] = {"Neither","Auto","Manual","Both"};
    
/** \brief array of structures of valid parameters */
struct parameterInfo parameters[] = 
{
     {"spi","NA","","SPI Register",REGISTER,"C",READWRITE,80,20,80,0.0,0.0,0.0,NULL,readSPIReg,NULL,writeSPIReg,NULL,NULL},
     {"i2c","NA","","I2C Register",REGISTER,"C",READWRITE,80,20,80,0.0,0.0,0.0,NULL,readI2CReg,NULL,writeI2CReg,NULL,NULL},
   #if 0
    {"I5V0_PG","P1.3","NA","5 Volt Power Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,I5V0_PG_Read,NULL,NULL,NULL},
    {"I24V0_PG","P1.4","J3-1","24 Volt Power Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,I24V0_PG_Read,NULL,NULL,NULL},
    {"HV_CONTACTOR_CTRL","P15.2","J6-1,2","HV Contactor Control Output",BINARY,"",READWRITE,0,0,1,0.0,0.0,0.0,HV_CONTACTOR_CTRL_Read,HV_CONTACTOR_CTRL_Write,NULL,NULL},
    {"HV_ENABLE","P6.4","J1-9","HV Enable Output",BINARY,"",READWRITE,0,0,1,0.0,0.0,0.0,HV_ENABLE_Read,HV_ENABLE_Write,NULL,NULL},
    {"HV_ENABLE_N","P6.5","J1-8","HV Enable Not Output",BINARY,"",READWRITE,1,0,1,0.0,0.0,0.0,HV_ENABLE_N_Read,HV_ENABLE_N_Write,NULL,NULL},
    {"TRIAC_IGN_CTRL","P5.2","J2-9","TRIAC Ignition Control Output",BINARY,"",READWRITE,0,0,1,0.0,0.0,0.0,TRIAC_IGN_CTRL_Read,TRIAC_IGN_CTRL_Write,NULL,NULL},
    {"PHASE_AB_UV","P6.7","J2-5","Phase AB Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,PHASE_AB_UV_Read_cmd,NULL,NULL,NULL},
    {"PHASE_AC_UV","P5.1","J2-7","Phase AC Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,PHASE_AC_UV_Read_cmd,NULL,NULL,NULL},
    {"PHASE_BC_UV","P5.0","J2-6","Phase BC Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,PHASE_BC_UV_Read_cmd,NULL,NULL,NULL},
    {"UTIL_OC_FLAG","P6.6","J2-4","Utility Over Current Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,UTIL_OC_FLAG_Read,NULL,NULL,NULL},
    {"BRIDGE_OC_FLAG","P2.5","J1-2","Bridge Over Current Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,BRIDGE_OC_FLAG_Read,NULL,NULL,NULL},
    {"OUTPUT_OC_FLAG","P2.6","J1-3","Output Over Current Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,OUTPUT_OC_FLAG_Read,NULL,NULL,NULL},
    {"HV_ENGAGED","P2.1","J10-1","HV Engaged Output",BINARY,"",READWRITE,0,0,1,0.0,0.0,0.0,HV_ENGAGED_Read,HV_ENGAGED_Write,NULL,NULL},
    {"HV_NOT_ENGAGED","P2.0","J10-1","HV Not Engaged Output",BINARY,"",READWRITE,1,0,1,0.0,0.0,0.0,HV_NOT_ENGAGED_Read,HV_NOT_ENGAGED_Write,NULL,NULL},
    {"SOFT_START_RELAY_CTRL","P5.3","J2-11","Soft Start Relay Control Output",BINARY,"",READWRITE,0,0,1,0.0,0.0,0.0,SOFT_START_RELAY_CTRL_Read,SOFT_START_RELAY_CTRL_Write,NULL,NULL},
    {"BRIDGE_OC_ER","P5.7","J4-1","Bridge Over Current Output",BINARY,"",READWRITE,0,0,1,0.0,0.0,0.0,BRIDGE_OC_ER_Read,BRIDGE_OC_ER_Write,NULL,NULL},
    {"OUTPUT_OC_ER","P5.6","J4-2","Output Over Current Output",BINARY,"",READWRITE,0,0,1,0.0,0.0,0.0,OUTPUT_OC_ER_Read,OUTPUT_OC_ER_Write,NULL,NULL},
    {"CUS_PERIM_INTLCK","P15.6","J4-3","Customer Perimeter Interlock Output",BINARY,"",READWRITE,0,0,1,0.0,0.0,0.0,CUS_PERIM_INTLCK_Read,CUS_PERIM_INTLCK_Write,NULL,NULL},
    {"CURRENT_FLDBCK_STATUS","P5.5","J4-4","Current Foldback Status Output",BINARY,"",READWRITE,0,0,1,0.0,0.0,0.0,CURRENT_FLDBCK_STATUS_Read,CURRENT_FLDBCK_STATUS_Write,NULL,NULL},
    {"IGN_FAIL_ER","P15.7","J4-5","Ignition Failure Output",BINARY,"",READWRITE,0,0,1,0.0,0.0,0.0,IGN_FAIL_ER_Read,IGN_FAIL_ER_Write,NULL,NULL},
    {"LOW_INP_PHA_VOLT","P5.4","J4-6","Low Input Phase Voltage Output",BINARY,"",READWRITE,0,0,1,0.0,0.0,0.0,LOW_INP_PHA_VOLT_Read,LOW_INP_PHA_VOLT_Write,NULL,NULL},
    {"QUENCH_STATUS","P15.0","J4-7","Quench Status Output",BINARY,"",READWRITE,0,0,1,0.0,0.0,0.0,QUENCH_STATUS_Read,QUENCH_STATUS_Write,NULL,NULL},
    {"E_STOP_FLG","P12.7","J4-8","E Stop Output",BINARY,"",READWRITE,0,0,1,0.0,0.0,0.0,E_STOP_FLG_Read,E_STOP_FLG_Write,NULL,NULL},
    {"CTRL_SYS_FAULT","P15.1","J4-9","Control Sysytem Fault Output",BINARY,"",READWRITE,0,0,1,0.0,0.0,0.0,CTRL_SYS_FAULT_Read,CTRL_SYS_FAULT_Write,NULL,NULL},
    {"DRIVER_BRD_OTEMP","P12.6","J4-10","Driver Board Over Temperature Output",BINARY,"",READWRITE,0,0,1,0.0,0.0,0.0,DRIVER_BRD_OTEMP_Read,DRIVER_BRD_OTEMP_Write,NULL,NULL},
    {"TEMP","P0-0,1,2","J11-1,2","Thermistor temperature",ANALOG,"C",READONLY,0,0,100,0.0,0.0,0.0,readTemp,NULL,NULL,NULL},
    {"TEMP_SET","NA","","Thermistor temperature trigger value",DIGITAL,"C",READWRITE,80,20,80,0.0,0.0,0.0,readTempSet,NULL,writeTempSet,NULL},
    {"PWM_DC","P2.7","J1-6","PWM Duty Cycle Output",DIGITAL,"%",READWRITE,25,0,99,0.0,0.0,0.0,readPWMDC,NULL,writePWMDC,NULL},
    {"PWM_DC_MIN","P2.7","J1-6","PWM Duty Cycle Minimum Output",DIGITAL,"%",READWRITE,0,0,99,0.0,0.0,0.0,readPWMDCMin,NULL,writePWMDCMin,NULL},
    {"PWM_DC_MAX","P2.7","J1-6","PWM Duty Maximum Cycle Output",DIGITAL,"%",READWRITE,99,0,99,0.0,0.0,0.0,readPWMDCMax,NULL,writePWMDCMax,NULL},
    {"CURRENT_SOURCE","Px.x","","Current Source",DIGITAL,"",READWRITE,2,0,3,0.0,0.0,0.0,readCurrentSource,NULL,writeCurrentSource,NULL},
    {"CURRENT_OFF_MAX","Px.x","","Current OFF Maximum Limit",ANALOG,"A",READWRITE,0,0,0,0.75,0.0,1.0,readCurrentOffMax,NULL,NULL,writeCurrentOffMax},
    {"CURRENT_STARTUP_MIN","Px.x","","Current Startup Minimum Limit",ANALOG,"A",READWRITE,0,0,0,3.0,1.0,4.0,readCurrentStartupMin,NULL,NULL,writeCurrentStartupMin},
    {"CURRENT_STABLE_MIN","Px.x","","Current Startup Minimum Limit",ANALOG,"A",READWRITE,0,0,0,2.0,0.5,5.0,readCurrentStableMin,NULL,NULL,writeCurrentStableMin},
    {"CURRENT_STABLE_MAX","Px.x","","Current Startup Minimum Limit",ANALOG,"A",READWRITE,0,0,0,10.0,1.0,12.0,readCurrentStableMax,NULL,NULL,writeCurrentStableMax},
    {"CURRENT0","Px.x","","Current 0 command register",ANALOG,"A",READWRITE,0,0,0,0.0,0.0,12.0,readCurrent0,NULL,NULL,writeCurrent0},
    {"CURRENT1","Px.x","","Current 1 command register",ANALOG,"A",READWRITE,0,0,0,0.0,0.0,12.0,readCurrent1,NULL,NULL,writeCurrent1},
    {"CURRENT2","P0-5-6","J5-4","Current 2 command register",ANALOG,"A",READONLY,0,0,0,0.0,0.1,1.02,readCurrent2,NULL,NULL,NULL},
    {"CURRENT3","P0-5-6","J5-5","Current 3 command register",ANALOG,"A",READONLY,0,0,0,0.0,0.1,1.02,readCurrent3,NULL,NULL,NULL},
    {"CURRENT_SAMPLE_RATE","NA","","current sample rate",DIGITAL,"ms",READWRITE,10,10,60000,0.0,0.0,0.0,readCurrentSampleRate,NULL,writeCurrentSampleRate,NULL},
    {"AMPS_PER_VOLT","Px.x","","Amps per volt",ANALOG,"Amps/Volt",READWRITE,0,0,0,2.5,1.0,4.5,readAmpsPerVolt,NULL,NULL,writeAmpsPerVolt},
    {"AUTO_AUTO_MAN_IGN_SELECT","P3.2","J8-1","Auto Ignition Switch Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,AUTO_AUTO_MAN_IGN_SELECT_Read,NULL,NULL,NULL},
    {"MAN_AUTO_MAN_IGN_SELECT","P3.3","J8-2","Manual Ignition Switch Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,MAN_AUTO_MAN_IGN_SELECT_Read,NULL,NULL,NULL},
    {"MAN_IGN_CTRL","P3.4","J8-4","Manual Ignition Control Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,MAN_IGN_CTRL_Read,NULL,NULL,NULL},
    {"E_STOP","P3.5","J8-6","Emergency Stop Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,E_STOP_Read,NULL,NULL,NULL},
    {"ENG_HV_NO_SW","P3.6","J8-7","Engage HV Normally Open Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,ENG_HV_NO_SW_Read,NULL,NULL,NULL},
    {"ENG_HV_NC_SW","P3.7","J8-8","Engage HV Normally Closed Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,ENG_HV_NC_SW_Read,NULL,NULL,NULL},
    {"PEND_INC_CURRENT","P4.2","J9-3","Pendant Increment Current Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,PEND_INC_CURRENT_Read_INV,NULL,NULL,NULL},
    {"PEND_DEC_CURRENT","P4.3","J9-4","Pendant Decrement Current Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,PEND_DEC_CURRENT_Read_INV,NULL,NULL,NULL},
    {"PEND_HV_NO_SW","P4.4","J9-5","Pendant HV Normally Open Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,PEND_HV_NO_SW_Read_INV,NULL,NULL,NULL},
    {"PEND_HV_NC_SW","P4.5","J9-6","Pendant HV Normally Closed Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,PEND_HV_NC_SW_Read_INV,NULL,NULL,NULL},
    {"PEND_DISENGAGE_HV","P4.6","J9-7","Pendant Disengage HV Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,PEND_DISENGAGE_HV_Read_INV,NULL,NULL,NULL},
    {"PEND_PRESENT","P4.7","J9-8","Pendant Present Input",BINARY,"",READONLY,0,0,1,0.0,0.0,0.0,PEND_PRESENT_Read_CMD,NULL,NULL,NULL},
    {"ENCODER_COUNTER","P3.0,1","J7-2,3","Encoder Counter",DIGITAL,"Counts",READWRITE,0,0,65535,0.0,0.0,0.0,readEncoderCounter,NULL,ENCODER_COUNTER_WriteCounter,NULL},
    {"LAMP_TEST_TIME","NA","","Lamp Test Time",DIGITAL,"ms",READWRITE,1000,100,60000,0.0,0.0,0.0,readLampTestTime,NULL,writeLampTestTime,NULL},
    {"PENDANT_TEST_TIME","NA","","Lamp Test Time",DIGITAL,"us x 100",READWRITE,5,5,20,0.0,0.0,0.0,readPendantTestTime,NULL,writePendantTestTime,NULL},
    {"IGNITION_TIME","NA","","Ignition Time",DIGITAL,"ms",READWRITE,1000,100,3000,0.0,0.0,0.0,readIgnitionTime,NULL,writeIgnitionTime,NULL},
    {"SOFT_START_TIME","NA","","Ignition Time",DIGITAL,"ms",READWRITE,200,200,2500,0.0,0.0,0.0,readSoftStartTime,NULL,writeSoftStartTime,NULL},
    {"CURRENT_STABLE_TIME","NA","","Current Stable Time",DIGITAL,"ms",READWRITE,2000,200,3000,0.0,0.0,0.0,readCurrentStableTime,NULL,writeCurrentStableTime,NULL},
    {"CURRENT_START_TIME","NA","","Current Start Time",DIGITAL,"ms",READWRITE,10,200,3000,0.0,0.0,0.0,readCurrentStartTime,NULL,writeCurrentStartTime,NULL},
    {"CURRENT_MIN_TIME","NA","","Current Minimum Test Time",DIGITAL,"ms",READWRITE,200,200,3000,0.0,0.0,0.0,readCurrentMinTime,NULL,writeCurrentMinTime,NULL},
    {"CURRENT_RAMP_RATE_TERMINATE","NA","","Current Ramp Rate for terminate",DIGITAL,"us x 100",READWRITE,5000,200,50000,0.0,0.0,0.0,readCurrentRampRateTerminate,NULL,writeCurrentRampRateTerminate,NULL},
    {"CURRENT_RAMP_RATE_FOLDBACK","NA","","Current Ramp Rate for foldback",DIGITAL,"us x 100",READWRITE,3000,200,50000,0.0,0.0,0.0,readCurrentRampRateFoldback,NULL,writeCurrentRampRateFoldback,NULL},
    {"CURRENT_RAMP_RATE_ENCODER","NA","","Current Ramp Rate for encoder",DIGITAL,"us x 100",READWRITE,1000,200,50000,0.0,0.0,0.0,readCurrentRampRateEncoder,NULL,writeCurrentRampRateEncoder,NULL},
    {"ENCODER_SAMPLE_RATE","NA","","Encoder Sample Rate",DIGITAL,"us x 100",READWRITE,1000,200,30000,0.0,0.0,0.0,readEncoderSampleRate,NULL,writeEncoderSampleRate,NULL},
#endif
    {"End","","","",BINARY,"",READONLY,0,0,0,0,0,0,NULL,NULL,NULL,NULL},
};
/* [] END OF FILE */
