/**********************************************************************************
 * This program monitors the power on state, kill state and battery voltage on
 * Woodstream mouse trap using the Multitech mDot and UDK2 development system.
 * The power on state is monitored on the PA_4(UDK2 Pin D10)and the kill state is
 * monitored on the PA_5 (UDK2 Pin D13) Digital Input Pins.  The battery voltage
 * is monitored on the PB_1 (UDK2 Pin A0) Analog Input.  The status of these pins
 * are transferred from the mDot LoRa to the Conduit LoRa gateway.  The status is
 * also shown on the USB Debug Terminal Window.
 *********************************************************************************/

#include "mbed.h"
#include "mDot.h"
#include "MTSLog.h"
#include <string>
#include <vector>
#include <algorithm>
#include "PinDetect.h"
#include "common.h"

#define I2C_TIME 5
#define LED_TIME 1
#define BATTERY_TIME 2.0
#define KILL_STATUS_TIME 3.0
#define POWER_ON_TIME 4.0

//mDot* dot;
Ticker ledTimer;
Ticker batteryTimer;
Ticker killStatusTimer;
Ticker powerOnTimer;
     
AnalogIn batteryVoltage(PTB0);
DigitalIn powerOn(PTC1);        /* SW2 */
DigitalIn killStatus(PTB17);    /* SW3 */
DigitalOut led_red(PTA1);
DigitalOut led_green(PTA2);
//DigitalOut led_blue(PTD5);
DigitalOut spi_cs(PTD4);

//Serial pc(PTE0, PTE1);
Serial pc(PTD3, PTD2);

// Configuration variables
static std::string config_network_name = "LORA_NET";
static std::string config_network_pass = "BLUE_HEN1";
static uint8_t config_frequency_sub_band = 7;

//Global Variables
bool readyToSendI2C;
bool readyToSendBatteryVoltage;
bool readyToSendKillStatus;
bool readyToSendPowerOn;
float lastBatteryVoltage;
uint8_t lastKillStatus;
uint8_t lastPowerOn;

//Function prototypes
void timeOfDay();
void periodicSendTock();
void batteryRead();
void killStatusRead();
void powerOnRead();
void printError(mDot* dot, int32_t returnCode);
void printVersion();
bool setFrequencySubBand(uint8_t subBand);
bool setNetworkName(const std::string name);
bool setNetworkPassphrase(const std::string passphrase);
bool setTxDataRate(const int dataRate);
bool setPower(uint8_t power);
bool setAck(uint8_t retries);
bool joinNetwork();
bool send(const std::string text);
I2C i2c_mem(PTB3,PTB2);
//SPI spi_rf(PTD6, PTD7, PTD5, PTD4);
SPI spi_rf(PTD6, PTD7, PTD5);

int i2cAddr = 0xAA;
char data[0x10];
char data1[0x10];

int main()
{
    bool configFail = false;
    int ack;
    
    readyToSendI2C = false;
    readyToSendBatteryVoltage = false;
    readyToSendKillStatus = false;
    readyToSendPowerOn = false;
    lastBatteryVoltage = 0.0;
    lastKillStatus = killStatus;
    lastPowerOn = powerOn;
    
    i2c_mem.frequency(100000);
    
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
 //   spi_rf.format(16,3);
    spi_rf.format(16,0);
    spi_rf.frequency(1000000);
    spi_cs = 1;
  
    //Start LED startup sequence
    ledTimer.attach(&timeOfDay, LED_TIME);
 
    pc.baud(115200);
 //   pc.printf("\r\n\r\n");
 //   pc.printf("=====================================\r\n");
//    pc.printf("JLC MT Demo \r\n");
//    pc.printf("=====================================\r\n");
    
    // get the mDot handle
//     dot = mDot::getInstance();  
 /*    dot->setLogLevel(mts::MTSLog::INFO_LEVEL);

    //*******************************************
    // configuration
    //*******************************************
    // reset to default config so we know what state we're in
    dot->resetNetworkSession();
    dot->resetConfig();

    // set up the mDot with our network information: frequency sub band, network name, and network password
    // these can all be saved in NVM so they don't need to be set every time - see mDot::saveConfig()    
    configFail = !setFrequencySubBand(config_frequency_sub_band);
    configFail |= !setNetworkName(config_network_name);
    configFail |= !setNetworkPassphrase(config_network_pass);
    configFail |= !setTxDataRate(mDot::SF_8);
    configFail |= !setPower(20);                                    // Reduce latency for 868 units
    configFail |= !setAck(0);                                       // Disable ack for less latency
    
    printf("Configration %s\r\n",configFail?"Failed":"Passed");
     
    // save this configuration to the mDot's NVM
    printf("saving config\r\n");
    if (! dot->saveConfig())
    {
        logError("failed to save configuration");
    }
    //*******************************************
    // end of configuration
    //*******************************************
  
    // keep trying to join the network
    while (!joinNetwork()) 
    { 
        wait(200); 
        dot->resetNetworkSession(); 
    }
*/
    // Stop LED startup sequence & configure them for operation
    led_red = 1;
    led_green = 1;
 //   led_blue = 1;
    // start all paramter timers to sample analog and digital inputs
//    batteryTimer.attach(batteryRead, BATTERY_TIME);
//    killStatusTimer.attach(killStatusRead, KILL_STATUS_TIME);
//    powerOnTimer.attach(powerOnRead, POWER_ON_TIME);
    
    /* initialize time and date */
    epoch =0;
    
     /* Send message to verify UART is connected properly */
    printVersion();
    sprintf(TransmitBuffer,"%s cmd>",time_string);
    pc.printf(TransmitBuffer);

    while (1) 
    {
         if (getLine() == 1)                     /* wait until command line complete */
        {
            executeCmd();
            sprintf(TransmitBuffer,"%s cmd> ",time_string);
            pc.printf("%s",TransmitBuffer);
         }
       #if 0
        // is there anything to send
        if(readyToSendI2C)
        {       
        #if 0
            data[0] = 0x12;
            data[1] = 0x34;
            data[2] = 0x56;
            myI2CWrite(0,data,3);
            myI2CRead(0,data1,3);
            sprintf(latestData,"I2c %02X %02X %02X",data1[0], data1[1], data1[2]);
            pc.printf("%s\r\n",latestData);
        #endif
            
        #if 1
            // Send 0x8f, the command to read the WHOAMI register
             data[0] = 0x12;
           mySPIWrite(0x0A,data,1);
            mySPIRead(0x0A,data1,1);
           mySPIRead(0x42,data1,2);
 //            int spiData = spi_rf.write(0x0600 | 0x0000);
            sprintf(latestData,"SPI %02X %02X",data1[0], data1[1]);
            pc.printf("%s\r\n",latestData);
  
         #endif
            send(latestData);
            readyToSendI2C = false;
        }
        if(readyToSendBatteryVoltage)
        {       
            sprintf(latestData,"Voltage %2.2f",(double)lastBatteryVoltage);
            pc.printf("%s\r\n",latestData);
            send(latestData);
            readyToSendBatteryVoltage = false;
        }
        if(readyToSendKillStatus)
        {       
            sprintf(latestData,"KillStatus %d",lastKillStatus);
            pc.printf("%s\r\n",latestData);
            send(latestData);
            readyToSendKillStatus = false;
        }
        if(readyToSendPowerOn)
        {       
            sprintf(latestData,"PowerOn %d",lastPowerOn);
            pc.printf("%s\r\n",latestData);
            send(latestData);
            readyToSendPowerOn = false;
        }
        #endif
     }
}

void I2CWrite(uint16 addr, uint8 *data, int length)
{   
    int i;
    char bytes[3];
 
    for(i=0; i< length; i++,addr++)
    {
        bytes[0] = addr >> 8;
        bytes[1] = addr & 0xFF;
        bytes[2] = data[i];
        i2c_mem.write(i2cAddr, bytes, 3);               /* write address and one byte */
        while(i2c_mem.write(i2cAddr, bytes, 0) != 0);   /* wait till write complete */
    }
    return;
} 

void I2CRead(uint16 addr, uint8 *data, int length)
{   
    char bytes[2];
 
    bytes[0] = addr >> 8;
    bytes[1] = addr & 0xFF;
//    sprintf(TransmitBuffer,"read I2C %04X %02X %04X\r\n",regAddress, bytes[0], bytes[1]);
//    pc.printf(TransmitBuffer); 
    i2c_mem.write(i2cAddr, bytes, 2,true);      /* write address with repeated start */
    i2c_mem.read(i2cAddr, (char *)data, length);        /* read all bytes */
    return;
}


void SPIWrite(uint16 addr, uint8 *data, int length)
{   
    int i;
    
    for(i=0;i<length;i++,addr++)
    {
        spi_cs = 0;
        data[i] = spi_rf.write( (addr << 8) | data[i] | 0x8000);
        spi_cs = 1;
    }
}

void SPIRead(uint16 addr, uint8 *data, int length)
{   
    int i;
    
    for(i=0;i<length;i++,addr++)
    {
        spi_cs = 0;
        data[i] = spi_rf.write( (addr << 8) | data[i] | 0x0000);
        spi_cs = 1;
    }
  }

void timeOfDay()
{
   epoch++;                     /* update time of day */
   led_red = !led_red;
//    led_green = !led_green;
//   led_blue = !led_blue;
    readyToSendI2C = true;
  }

void batteryRead() 
{
    lastBatteryVoltage = batteryVoltage * (float)3.3;
    readyToSendBatteryVoltage = true;
}

void killStatusRead() 
{   
    lastKillStatus = killStatus;
    readyToSendKillStatus = true;
}

void powerOnRead() 
{   
    lastPowerOn = powerOn;
    readyToSendPowerOn = true;
 }

bool setFrequencySubBand(uint8_t subBand)
{
/*    int32_t returnCode;
    
    printf("Setting frequency sub band to '%d'...\r\n", subBand);
    if ((returnCode = dot->setFrequencySubBand(subBand)) != mDot::MDOT_OK) {
        printError(dot, returnCode);
        return false;
    }
    return true;
*/
}

bool setNetworkName(const std::string name)
{
 /*   int32_t returnCode;
    
    printf("Setting network name to '%s'...\r\n", name.c_str());
    if ((returnCode = dot->setNetworkName(name)) != mDot::MDOT_OK)
    {
        printError(dot, returnCode);
        return false;
    }
    return true;
*/}

bool setNetworkPassphrase(const std::string passphrase)
{
 /*   int32_t returnCode;
    
    printf("Setting passphrase to '%s'...\r\n", passphrase.c_str());
    if ((returnCode = dot->setNetworkPassphrase(passphrase)) != mDot::MDOT_OK)
    {
        printError(dot, returnCode);
        return false;
    }
    return true;
*/}

bool setTxDataRate(const int dataRate)
{
 /*  int32_t returnCode;
   
    printf("Setting TX Spreading factor to %d...\r\n",dataRate);
    if ((returnCode = dot->setTxDataRate(dataRate)) != mDot::MDOT_OK) 
    {
        logError("Failed To Set Tx Datarate %d:%s", returnCode, mDot::getReturnCodeString(returnCode).c_str());
        printError(dot, returnCode);
        return false;
    }
    return true;
*/}

bool setPower(uint8_t power)
{
 /*   int32_t returnCode;
    printf("Setting tx power to '%d'...\r\n", power);
    if ((returnCode = dot->setTxPower(power)) != mDot::MDOT_OK) 
    {
        printError(dot, returnCode);
        return false;
    }
    return true;
*/}

bool joinNetwork()
{
 /*   int32_t returnCode;
    printf("\r\nJoining network...\r\n");
    if ((returnCode = dot->joinNetworkOnce()) != mDot::MDOT_OK) 
    {
        printError(dot, returnCode);
        return false;
    }
    printf("Network Joined!\r\n");
    return true;
*/}

bool setAck(uint8_t retries)
{
 /*   int32_t returnCode;
    printf("Setting ack to '%d'...\r\n", retries);
    if ((returnCode = dot->setAck(retries)) != mDot::MDOT_OK)
    {
        printError(dot, returnCode);
        return false;
    }
    return true;
*/}

bool send(const std::string text)
{
/*    int32_t returnCode;
    uint32_t timeTillSend = dot->getNextTxMs();
    if (timeTillSend != 0) {
        printf("waiting %lu ms to send\r\n", timeTillSend);
        return false;
    }

    printf("Sending data...  ");
    std::vector<uint8_t> data(text.begin(), text.end());
    if ((returnCode = dot->send(data, 1)) != mDot::MDOT_OK)
    {
        printError(dot, returnCode);
        return false;
    }
    printf("Data sent!\r\n");
    return true;
*/}

void printError(mDot* dot, int32_t returnCode)
{
//    std::string error = mDot::getReturnCodeString(returnCode) + " - " + dot->getLastError();
//    printf("%s\r\n", error.c_str());
 }

