/* ========================================
 * Filename: utilities.c
 *
 * Description: functions needed by other files
 *
 * Copyright J-Factor Embedded Technologies 2015
 * Copyright TJM Embedded Software 2015
 * All Rights Reserved
 * UNPUBLISHED, LICENSED SOFTWARE.
 *
 * CONFIDENTIAL AND PROPRIETARY INFORMATION
 * WHICH IS THE PROPERTY OF J-Factor Embedded Technologies.
 *
 * ========================================
*/
/** \file
 * \brief functions used by other files.
 */
#include <time.h>
#include "stdio.h"
#include "common.h"

/** 
 * \fn void date(void)
 *
 * \brief gets current time and date.
 *
 * gets date current time and date since last  set date command. there is no real time clock in the system so date is relative.
 * \return None<p>
 *
 */
void date(void)
{
    struct tm *epoch_tm = gmtime(&epoch);
    if(epoch_tm != NULL)
        c_time_string = asctime(gmtime(&epoch));
    else
        c_time_string = "00:00:00";
}


/** 
 * \fn void setDate(char *str)
 *
 * \brief gets current time and date.
 *
 * gets date current time and date since last  set date command. there is no real time clock in the system so date is relative.
 * \return None<p>
 *
 */
void setDate(char *str)
{
    struct tm t;
    int day,month,year,hour,minute,second;
    int num;
    time_t tempEpoch;
    
    num = sscanf(str,"%d/%d/%d %d:%d:%d",&month,&day,&year,&hour,&minute,&second);       /* get human readable current date */
    if(num != 6)
    {
        pc.printf("Illegal or missing parameters. expected 6 integers\r\nformat: Month Day Year Hour Minute Second\r\n");
        return;
    }
    t.tm_year = year-1900;
    t.tm_mon = month - 1;           // Month, 0 - jan
    t.tm_mday = day;          // Day of the month
    t.tm_hour = hour;     
    t.tm_min = minute;
    t.tm_sec = second;
    t.tm_isdst = -1;        // Is DST on? 1 = yes, 0 = no, -1 = unknown
    tempEpoch = mktime(&t); 
    if ( (month > 12) || (day > 31) || (hour > 23) || (minute > 59) || (second > 59) )
    {
        pc.printf("Illegal or missing parameters. expected 6 integers\r\nformat: Month/Day/Year Hour:Minute:Second\r\n");
        return;
    }
    epoch = tempEpoch;
}

void printVersion()
{
 //   pc.printf("%s Built on: %s %s\r\n\r\n", dot->getId().c_str(),__DATE__,__TIME__);
   pc.printf("\r\nJLC MT Demo: V%d.%02d %s Built on: %s %s\r\n",VERSION_MAJOR,VERSION_MINOR,VERSION_DATE, __DATE__,__TIME__);
}

uint8 tolower(uint8 c)
{
    if( (c >= 'A') && (c <= 'Z') )
        return (c | 0x20);
    else
        return c;
}

/** 
 * \fn float strtofloat (char *str)
 *
 * \brief converts an ASCII string to float.
 *
 * This routine converts a floating point number in the form
 * xx.yy to a floating point number.
 *
 * \param[in] str - pointer to a character string containing the floating point number
 * \return float - converted number<p>
 *
 */
float strtofloat (char *str)
{
    float result = 0.0;
    uint8 intPart[3];
    uint16 intValue = 0;
    uint8 floatPart[3];
    float floatValue = 0.0;
    uint8 i;
    char *ptrDecimalPoint = NULL;
    char *ptrStr = NULL;
    char ch;
    uint8 fractionValid = 0;
    uint8 integerValid = 0;
    
    for(i=0;i<sizeof(intPart);i++)      /* clear integer digits */
        intPart[i] = 0;
    for(i=0;i<sizeof(floatPart);i++)    /* floating digits */
        floatPart[i] = 0;
        
    ptrDecimalPoint = strchr(str, '.'); /* find the decimal point if any */
    if (ptrDecimalPoint != NULL)
    {
        fractionValid = 1;
        if(ptrDecimalPoint != str)      /* see if any integer digits */
            integerValid = 1;
    }
    else
    {
        integerValid = 1;
        ptrDecimalPoint = str + strlen(str);
    }
    
    if(integerValid)                    /* get and save all integer digits */
    {
        for(i=0, ptrStr = ptrDecimalPoint;ptrStr != str; i++)
        {
            ptrStr--;
            ch = *ptrStr;
            if( (ch >= '0') && (ch <= '9') )
            {
                intPart[i] = ch - '0';
            }
            else
            {
                fractionValid = 0;
                break;
            }
        }
        for(i=0;i<sizeof(intPart);i++)
            intValue += (intPart[i] * power(10,i));
    }
    
    if(fractionValid)                   /* get and save all fraction digits */
    {
        for(i=0, ptrStr = ptrDecimalPoint;ptrStr < str + strlen(str); i++)
        {
            ptrStr++;
            ch = *ptrStr;
            if( (ch >= '0') && (ch <= '9') )
            {
                floatPart[i] = ch - '0';
            }
            else
            {
                break;
            }
        }
        for(i=0;i<sizeof(floatPart);i++)
            floatValue += (floatPart[i] * (1.0/power(10,i+1)) );
    }
    result = intValue + floatValue;
    return result;
}

/** 
 * \fn uint16 power(uint8 num, uint8 pow)
 *
 * \brief takes number(num) to power(pow)
 *
 * This routine takes an 8 bit integer num and
 * raises it ot the power pow.
 *
 * \param[in] num - 8 bit integer number 
 * \param[in] pow - 8 bit power to raise num
 * \return uint16 - 16 bit num to the power pow<p>
 *
 */
uint16 power(uint8 num, uint8 pow)
{
    uint8 i;
    uint16 result = 1;
    
    for(i=0;i<pow;i++)
        result = result * num;
    return result;  
}
