#include "mbed.h"
#include "TIM_DMAInit.h"
#include "SPI_DMAInit.h"
#include "ILI9341.h"
#include "SCCB.h"
#include "GPIOInit.h"
/*

  ********ov7670********
   +3V3 - 3V3         GND-GND
  PC_12 - SIOC        SIDO - PC10
   PD_2 - VSYNC       HREF - A3
  B4,A4 - PCLK        XCLK - PC_9
   PB_7 - D7          D6 - PB_6
   PB_5 - D5          D4 - PB_4
   PB_3 - D3          D2 - PB_2
   PB_1 - D1          D0 - PB_0
+3V3-330Ω-RESET

  ********74HC00*********
A1          VCC - +3V3
B1          B4 -- PCLK
Y1          A4 -- PCLK
A2          Y4 - B3
B2          B3 - Y4
Y2          A3 - HREF
GND         Y3 - PA8

  ********ILI9341*********
SDO - PA6
LED - 10kΩ - +3V3
SCK - PA5
SDI - PA7
DC  - PA_4
RS  - PA_12
CS  - PA_11
GND - GND
VCC - +5V

  

*/

uint8_t dma_buf[145][300];
uint8_t flag_dma;

InterruptIn VSYNC(PD_2);
SPI spi(PA_7,PA_6,PA_5);
ili9341_spi lcd(spi,PA_11,PA_4,PA_12);
ov7670_sccb sccb(PC_10,PC_12);
PortIn cdata(PortB, 0x00ff);

void camdma_start();

int main() {


    gpio_Init();
    dma_init();
   
    spi.format(8,3);
    spi.frequency(20000000); 
    lcd.tft_reset(); 

 __disable_irq();
 
 VSYNC.rise(&camdma_start);    
 sccb.cam_init();

lcd.fillrect(0,0,149,144,0xf800);//red

wait(1);
 lcd.wr_cmd(0x2C);
 spi.write(0x66);
 spi_Init();
 
  __enable_irq();
  
  
    while(1) {
        }
}


void camdma_start()
{
if(flag_dma==0){
    HAL_DMA_Start_IT(&DMA_HandleType/*DMA初期設定構造体*/, (uint32_t)&GPIOB->IDR/*&0x00ff転送元アドレス*/, (uint32_t)dma_buf/*転送先アドレス*/,43500/*データ転送回数*/);

    HAL_SPI_Transmit_DMA(&spi1, (uint8_t*)dma_buf, sizeof(dma_buf));
}
flag_dma=1;
}