#include "mbed.h"


DMA_HandleTypeDef DMA_HandleType ={
    DMA2_Stream1,
    {
        DMA_CHANNEL_6,  // Request source is TIM_CH1
        DMA_PERIPH_TO_MEMORY,
        DMA_PINC_DISABLE,
        DMA_MINC_ENABLE,             
        DMA_PDATAALIGN_BYTE,
        DMA_MDATAALIGN_BYTE,
        DMA_CIRCULAR,//DMA_PFCTRL,//
        DMA_PRIORITY_VERY_HIGH,
        DMA_FIFOMODE_DISABLE,//DMA_FIFOMODE_ENABLE,
        DMA_FIFO_THRESHOLD_HALFFULL,
         DMA_PBURST_INC4 ,
        DMA_PBURST_SINGLE
    },
    HAL_UNLOCKED,
    HAL_DMA_STATE_RESET,//HAL_DMA_STATE_READY
    NULL, // parent
    NULL, //dma_transfer_complete, // XferCpltCallback
    NULL, // XferHalfCpltCallback
    NULL, // XferM1CpltCallback
    NULL, //dma_error, // XferErrorCallback
    NULL  // ErrorCode
};

TIM_HandleTypeDef         htim;



void dma_init(void)
{
    TIM_IC_InitTypeDef       icconf;
    GPIO_InitTypeDef gpioconf;   
    __DMA2_CLK_ENABLE();
    __TIM1_CLK_ENABLE();
    __GPIOA_CLK_ENABLE();

    
    
    /* PA8 -> TIM1_CH1  */
   
    gpioconf.Mode = GPIO_MODE_AF_OD;
     gpioconf.Pin = GPIO_PIN_8;
    gpioconf.Pull = GPIO_PULLUP;
    gpioconf.Speed = GPIO_SPEED_HIGH;
    gpioconf.Alternate = GPIO_AF1_TIM1;
    HAL_GPIO_Init(GPIOA, &gpioconf);

    HAL_DMA_Init(&DMA_HandleType);
 
    htim.Instance = TIM1;
    htim.Init.Period        = 1;
    htim.Init.Prescaler     = 0;
    htim.Init.ClockDivision = 0;
    htim.Init.CounterMode   = TIM_COUNTERMODE_UP;
    HAL_TIM_IC_Init(&htim);
    
    icconf.ICPolarity  = TIM_ICPOLARITY_FALLING;
    //icconf.ICPolarity  = TIM_ICPOLARITY_RISING;
    icconf.ICSelection = TIM_ICSELECTION_DIRECTTI;
    icconf.ICPrescaler = TIM_ICPSC_DIV1;
    icconf.ICFilter    = 0;
    HAL_TIM_IC_ConfigChannel(&htim, &icconf, TIM_CHANNEL_1);
    __HAL_TIM_ENABLE_DMA(&htim, TIM_DMA_CC1);
    
    /* Start the TIM1 Channel1 */
    HAL_TIM_IC_Start(&htim, TIM_CHANNEL_1);
    
}