#include "mbed.h"

 

DMA_HandleTypeDef    SPIDma;
SPI_HandleTypeDef   spi1;


void spi_Init() {
    
    
    __DMA2_CLK_ENABLE();
    SPIDma.Instance = DMA2_Stream3;
    SPIDma.Init.Channel = DMA_CHANNEL_3;
    SPIDma.Init.Direction = DMA_MEMORY_TO_PERIPH;
    SPIDma.Init.PeriphInc = DMA_PINC_DISABLE;
    SPIDma.Init.MemInc = DMA_MINC_ENABLE;
    SPIDma.Init.PeriphDataAlignment = DMA_PDATAALIGN_BYTE;  // 8 bit
    SPIDma.Init.MemDataAlignment = DMA_PDATAALIGN_BYTE;     // 8 bit
    SPIDma.Init.Mode =   DMA_CIRCULAR;
    SPIDma.Init.Priority = DMA_PRIORITY_HIGH;
    SPIDma.Init.FIFOMode = DMA_FIFOMODE_DISABLE;
    HAL_DMA_Init(&SPIDma);
    
    // SPI pin
    __GPIOA_CLK_ENABLE();
    GPIO_InitTypeDef spipins;
    spipins.Pin = GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_7;
    spipins.Mode = GPIO_MODE_AF_PP;
    spipins.Pull = GPIO_PULLDOWN;
    spipins.Speed = GPIO_SPEED_HIGH;
    spipins.Alternate =  GPIO_AF5_SPI1;
    HAL_GPIO_Init(GPIOA, &spipins);
    
 // SPI
   __SPI1_CLK_ENABLE();
    spi1.Init.Mode = SPI_MODE_MASTER;
    spi1.Init.Direction = SPI_DIRECTION_2LINES;
    spi1.Init.DataSize = SPI_DATASIZE_8BIT;
    spi1.Init.CLKPolarity= SPI_POLARITY_LOW;//パリティビット無し
    spi1.Init.CLKPhase = SPI_PHASE_1EDGE;    // transmit only mode 送信のみ
    spi1.Init.NSS = SPI_NSS_SOFT; 
    spi1.Init.BaudRatePrescaler = SPI_BAUDRATEPRESCALER_2; 
    spi1.Init.FirstBit = SPI_FIRSTBIT_MSB ;
    spi1.Init.CRCPolynomial = 7;

    spi1.Instance = SPI1;
    spi1.hdmatx = &SPIDma;
   HAL_SPI_Init(&spi1);
     
    
}
