
#include <mbed.h>
#include "SCCB.h"

ov7670_sccb::ov7670_sccb(PinName _SDA,PinName _SCL) :  SDA(_SDA),SCL(_SCL) {}


void ov7670_sccb::I2cstart(void)
{
SDA=1;SCL=1;        /* SCL,SDAは常時Highとする　*/
        wait_us(2);
      SDA=0;
      wait_us(2);                                   // SDA出力
}

void ov7670_sccb::I2cstop(void)
{
          SCL=0;                                                // 先にSDA Low
        wait_us(2);
        SDA=0;                                              // SCL Low
        wait_us(2);
       SCL=1;                                          // SDA Low                                      // 出力モードに戻す　SDA =Low
        wait_us(2);
         SDA=1;                                             // 先にSCLをHigh
        wait_us(2);
                                                        // 後からSDAをHigh

}
void ov7670_sccb::I2cout(unsigned char datar)
{
        int ia;
       for(ia=0;ia<8;ia++){
          SCL=0;
          if(datar & 0x80){SDA=1;}
          else SDA=0;
          datar<<=1;
           wait_us(1);
          SCL=1;
          wait_us(2);
          SCL=0;
          wait_us(1);//wait();
       }
        wait_us(1);
          
          SCL=1;
          datar<<=1;
          wait_us(2);
          SCL=0;
           
           wait_us(1);
}

void ov7670_sccb:: c(unsigned char adrs,unsigned char datak)
{
    I2cstart();
    I2cout(0x42);
    I2cout(adrs);
    I2cout(datak);
    I2cstop();
         wait_ms(10);
}
void ov7670_sccb::cam_init(){
        c(REG_COM7, COM7_RESET);                        //0x12:COM7(Reset,QCIF,Cbar,RGBformat)
        wait_ms(200);                                                //200ms

        c(REG_COM7,COM7_RGB|COM7_FMT_QCIF);                //0x12:COM7        ,  0x0C)        //QCIF, RGB
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
        c(REG_RGB444, 0x00);        //0x8c:RGB 444 control
        c(REG_COM1, 0x00); //0x40                                               //0x04:COM1(CCIR656,AEC)        //0)        //0x40)
        c(REG_COM15, COM15_R01FE|COM15_RGB565);        //0x40:COM15

        c(REG_COM9, 0x68);                        // 38 0x14:COM9=max AGC gain ceiling, Freeze AGC/AEC

       //c(0x3d,0xc3);        //(REG_COM13, COM13_GAMMA|COM13_UVSAT|0x2)        //0x3d:COM13
        c(REG_HAECC7,0x94);                //0xaa:Hist AEC/AGC control 7        c(0xAA,0x94)        //AEC algorithm

        c(REG_TSLB,0x04);                //0x3a:Neg,UVval,YUYV,window        TSLB_YLAST)                //0x04)        //0x0C)        //0x80)        //0x00)        //0x04)
        c(0x20,0x04);                        //ADCCTR0, A/D range&ref, mu0102

        /******* ringo *********/
       c(REG_COM8,0xfd); //AGC,AWB OFF,res OK

         c(0x10,0x0f);//AECコントロール（中位ビット）
         c(0x07,0x00);//AECコントロール（上位ビット）
        //by Mr.Shiono

        c(0x01,0x40);
        c(0x02,0x60);
        c(0x03,0x0a);
        c(0x0c,0x00);
        c(0x0e,0x61);
        c(0x0f,0x4b);
        c(0x15,0x00);
        c(0x16,0x02);
        c(0x17,0x18); //HSTART
        c(0x18,0x01);
        c(0x19,0x02);
        c(0x1a,0x7a);
        c(0x1e,0x07);
        c(0x21,0x02);
        c(0x22,0x91);
        c(0x29,0x07);
        c(0x32,0xb6);
        c(0x33,0x0b);
        c(0x34,0x11);
        c(0x35,0x0b);
        c(0x37,0x1d);
        c(0x38,0x71);
        c(0x39,0x2a);
        c(0x3b,0x92);//com11 ナイトモード
        c(0x3c,0x78);
        c(0x3d,0xc3);
        c(0x3e,0x00);
        c(0x3f,0x00);
        c(0x41,0x08);
        c(0x41,0x38);
        c(0x43,0x0a);
        c(0x44,0xf0);
        c(0x45,0x34);
        c(0x46,0x58);
        c(0x47,0x28);
        c(0x48,0x3a);
        c(0x4b,0x09);
        c(0x4c,0x00);
        c(0x4d,0x40);
        c(0x4e,0x20);
        c(0x4f,0x80);//c(0x4f,0x80);    彩度調整
        c(0x50,0x80);//c(0x50,0x80);
        c(0x51,0x00);
        c(0x52,0x22);//c(0x52,0x22);
        c(0x53,0x5e);//c(0x52,0x5e);
        c(0x54,0x80);//c(0x54,0x80);
        c(0x56,0x40);
        c(0x58,0x9e);
        c(0x59,0x88);
        c(0x5a,0x88);
        c(0x5b,0x44);
        c(0x5c,0x67);
        c(0x5d,0x49);
        c(0x5e,0x0e);
        c(0x69,0x00);
        c(0x6a,0x40);
        c(0x6b,0x0a);
        c(0x6c,0x0a);
        c(0x6d,0x55);
        c(0x6e,0x11);
        c(0x6f,0x9f);
        c(0x70,0x3a);
        c(0x71,0x35);
        c(0x72,0x11);
        c(0x73,0xf0);
        c(0x74,0x10);
        c(0x75,0x05);
        c(0x76,0xe1);
        c(0x77,0x01);
        c(0x78,0x04);
        c(0x79,0x01);
        c(0x8d,0x4f);
        c(0x8e,0x00);
        c(0x8f,0x00);
        c(0x90,0x00);
        c(0x91,0x00);
        c(0x96,0x00);
        c(0x96,0x00);                        //?
        c(0x97,0x30);
        c(0x98,0x20);
        c(0x99,0x30);
        c(0x9a,0x00);
        c(0x9a,0x84);                        //?
        c(0x9b,0x29);
        c(0x9c,0x03);
        c(0x9d,0x4c);
        c(0x9e,0x3f);
        c(0xa2,0x02);
        c(0xa4,0x88);
        c(0xb0,0x84);
        c(0xb1,0x0c);
        c(0xb2,0x0e);
        c(0xb3,0x82);
        c(0xb8,0x0a);
        c(0xc8,0xf0);
        c(0xc9,0x60);
        c(0x6b,0x40);//入力クロックｘ４
        c(REG_CLKRC,0x40);   //0xaf                     //PCLK*(1/48)

}
