#include "mbed.h"
uint8_t frame_buffer[145][300]={0xff,0xff};

DMA_HandleTypeDef    dcmi_Dma;
DCMI_HandleTypeDef  dcmi;

void dcmi_Init(){
    frame_buffer[100][0]=0xFF;
    frame_buffer[100][1]=0xFF;
    GPIO_InitTypeDef GPIO_InitStruct; 
    
  /*Configure GPIO pin : PA8 MCO1 for cam XCLK*/  
    HAL_RCC_MCOConfig(RCC_MCO1, RCC_MCO1SOURCE_HSE, RCC_MCODIV_1);   
    __GPIOA_CLK_ENABLE(); 
    GPIO_InitStruct.Pin = GPIO_PIN_8;    
    GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;    
    GPIO_InitStruct.Pull = GPIO_NOPULL;    
    GPIO_InitStruct.Speed = GPIO_SPEED_LOW;    
    GPIO_InitStruct.Alternate = GPIO_AF0_MCO;    
    HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);
    
    
    GPIO_InitTypeDef dcmipinsa,dcmipinsb,dcmipinsc;
    dcmipinsa.Pin = GPIO_PIN_4|GPIO_PIN_6;
    dcmipinsa.Mode = GPIO_MODE_AF_PP;
    dcmipinsa.Pull = GPIO_PULLDOWN;
    dcmipinsa.Speed = GPIO_SPEED_HIGH;
    dcmipinsa.Alternate =  GPIO_AF13_DCMI;
    HAL_GPIO_Init(GPIOA, &dcmipinsa);
    
    __GPIOB_CLK_ENABLE();
    dcmipinsb.Pin = GPIO_PIN_6|GPIO_PIN_7|GPIO_PIN_8|GPIO_PIN_9;
    dcmipinsb.Mode = GPIO_MODE_AF_PP;
    dcmipinsb.Pull = GPIO_PULLDOWN;
    dcmipinsb.Speed = GPIO_SPEED_HIGH;
    dcmipinsb.Alternate =  GPIO_AF13_DCMI;
    HAL_GPIO_Init(GPIOB, &dcmipinsb);
    
    __GPIOC_CLK_ENABLE();
    dcmipinsc.Pin = GPIO_PIN_6|GPIO_PIN_7|GPIO_PIN_8|GPIO_PIN_9|GPIO_PIN_11;
    dcmipinsc.Mode = GPIO_MODE_AF_PP;
    dcmipinsc.Pull = GPIO_PULLDOWN;
    dcmipinsc.Speed = GPIO_SPEED_HIGH;
    dcmipinsc.Alternate =  GPIO_AF13_DCMI;
    HAL_GPIO_Init(GPIOC, &dcmipinsc);
    
    __DMA2_CLK_ENABLE();
    dcmi_Dma.Instance = DMA2_Stream1;
    dcmi_Dma.Init.Channel = DMA_CHANNEL_1;
    dcmi_Dma.Init.Direction = DMA_PERIPH_TO_MEMORY;
    dcmi_Dma.Init.PeriphInc = DMA_PINC_DISABLE;
    dcmi_Dma.Init.MemInc = DMA_MINC_ENABLE;
    dcmi_Dma.Init.PeriphDataAlignment = DMA_PDATAALIGN_WORD;  
    dcmi_Dma.Init.MemDataAlignment = DMA_MDATAALIGN_HALFWORD ;
    dcmi_Dma.Init.Mode =   DMA_CIRCULAR;
    dcmi_Dma.Init.Priority = DMA_PRIORITY_HIGH;
    dcmi_Dma.Init.FIFOMode = DMA_FIFOMODE_ENABLE;
    dcmi_Dma.Init.FIFOThreshold =DMA_FIFO_THRESHOLD_FULL;
    dcmi_Dma.Init.MemBurst = DMA_PBURST_SINGLE;
    dcmi_Dma.Init.PeriphBurst = DMA_PBURST_SINGLE;
    
    HAL_DMA_Init(&dcmi_Dma);
    
    __DCMI_CLK_ENABLE();
    dcmi.Instance = DCMI;
    dcmi.Init.ExtendedDataMode = DCMI_EXTEND_DATA_8B; 
    dcmi.Init.CaptureRate = DCMI_CR_ALL_FRAME;   
    dcmi.Init.VSPolarity = DCMI_VSPOLARITY_HIGH;  
    dcmi.Init.HSPolarity = DCMI_HSPOLARITY_LOW; 
    dcmi.Init.PCKPolarity = DCMI_PCKPOLARITY_RISING;       
    dcmi.Init.SynchroMode = DCMI_SYNCHRO_HARDWARE;     
    dcmi.DMA_Handle = &dcmi_Dma;
    HAL_DCMI_Init(&dcmi);
     __HAL_DCMI_ENABLE(&dcmi);
    HAL_DCMI_Start_DMA(&dcmi, DCMI_MODE_CONTINUOUS, (uint32_t)&frame_buffer,43500/2);
    
    }
    
    
    
    
    
    
    
