#ifndef _STEERING_H
#define _STEERING_H

#include "mbed.h"
#include "rtos.h"
#include "KS0108.h"
#include "CANBuffer.h"
#include "LPCDigitalIn.h"
#include "LPCDigitalOut.h"
#include "CAN_Address.h"
#include "Buffers.h"

#define GET_FLOAT *(float*)((void*)(&Rxmsg.data[0]))

Serial pc(USBTX,USBRX);

AnalogOut ledstream(p18);  // This appears to iniialize the pin as an analog out, and probably defaults to low.  Without this, the LED bar would have a few lights on.

KS0108 display(p26, p21, p22, p23, p25, p24, p8, p7, p6, p5, p13, p14, p12, p11); 

LPCDigitalOut l1(p1_28,1);//    SW2  BR LED     1_28:1 & 1_26:0 makes the LED Green
LPCDigitalOut l2(p1_26,0);//    SW4  BR LED
    
LPCDigitalOut l3(p1_24,0);//    SW6  BL LED     1_24:0 & 0_24:1 makes the LED Red
LPCDigitalOut l4(p0_24,1);//    SW8  BL LED

LPCDigitalOut u1(p1_14,0);//    SW9  TR LED     1_14:0 & 1_09:1 makes the LED Green
LPCDigitalOut u2(p1_9,1);//     SW11 TR LED

LPCDigitalOut u3(p1_4,0);//     SW13 TL LED     1_04:0 & 1_00:1 makes the LED Green
LPCDigitalOut u4(p1_0,1);//     SW15 TL LED


LPCDigitalOut boSW1(p1_29,1);//            SW1   
LPCDigitalIn biSWBR(p1_27, PullDown);//    SW3,  BRight

LPCDigitalOut boSW5(p1_25,1);//            SW5
LPCDigitalIn biSWBL(p1_22, PullDown);//    SW7,  BLeft

LPCDigitalOut boSW10(p1_10,1);//           SW10
LPCDigitalIn biSWTR(p1_8, PullDown);//     SW12, TRight

LPCDigitalOut boSW14(p1_1,1);//            SW14
LPCDigitalIn biSWTL(p0_25, PullDown);//    SW16, TLeft

#endif //_STEERING_H