// FORMAT_CODE_START
// FORMAT_CODE_START
#include "Steering.h"

// Macro for printing to screen; Where y is the start poition of the text, and y2 is the start position of the variable
#define PUT2SCREEN(string, var, unit, x, y, y2)   display.PutString(x, y,  string);   display.PutString(x, y2, var);   display.PutString(x,y2+15,unit);

unsigned int x = 0;
unsigned int x_old = 0;
unsigned int x_new;
int diff = x_new-x_old;
int threshold = 1;
float y = 0.0;

void update_x(void const *args)
{
    while (1) {
        x++;
        wait_ms(1);         //I added this because the microcontroller was operating so fast that you couldn't read the numbers.
        if (x >= 16000) {
            x = 0;
        }

        x_new = x;
        diff = x_new - x_old;
    }
}

void update_y(void const *args)
{
    while(1) {
        y = y + 0.000001;
        if (y >= 1.0) {
            y = 0;

        }
    }

}

AnalogOut ledBar(p18);


int main()
{
    wait(1);

    Thread thread(update_x);

    Thread thread2(update_y);


    display.PutString(0, 42, "Live Test");

    PUT2SCREEN("CAN-1:",      CAN1Buffer,      "",     3,  0, 30);
    PUT2SCREEN("CAN-2:",      CAN2Buffer,      "",     3, 77,107);



    PUT2SCREEN("CAN-3:",      CAN3Buffer,      "",     5,  0, 30);
    PUT2SCREEN("CAN-4:",      CAN4Buffer,      "",     5, 77,107);

    while (1) {
        printf("x = %d y = %f\n", x, y);  //9600 baud (default)

        ledBar = y*(2.7/3.3);
        
        if (abs(diff) >= threshold) {
            display.GotoXY(30,24);
            //display.PutString(3,30, "   ");
            display.PrintInteger(x,3,30);
            display.PrintInteger(x,3,107);
            display.PrintInteger(x,5,30);
            display.PrintInteger(x,5,107);
            x_old = x_new;
        }
    }

}
// FORMAT_CODE_END
// FORMAT_CODE_END