#pragma once
#include "rtos.h"
#include "package_info.h"
#include "baidu_ca_object.h"

class OTAReporter
{
public:
    OTAReporter(const char *transaction_id);
    ~OTAReporter();
    enum {
        OTA_STATE_IDLE=0,
        OTA_STATE_DOWNLOADING,
        OTA_STATE_DOWNLOADED,
        OTA_STATE_INSTALLING,
        OTA_STATE_INSTALLED
    };
    enum {
        OTA_EVENT_BEGIN,
        OTA_EVENT_CONNECT_FAIL,
        OTA_EVENT_CONNECTION_LOST,
        OTA_EVENT_TIMEOUT,
        OTA_EVENT_DOWNLOADING,
        OTA_EVENT_DOWNLOAD_COMPLETE,
        OTA_EVENT_DOWNLOAD_FAIL,
        OTA_EVENT_INSTALLING,
        OTA_EVENT_IMAGE_INVALID,
        OTA_EVENT_WRITE_ERROR,
        OTA_EVENT_INSTALLED,
        OTA_EVENT_DELETED,
        OTA_EVENT_REJECT,
    };
    int report_state(int state, ...);
    int report_event(int event, ...);
    static int report_package_info(os_info_t& os);
    static void ota_report_status(duer::Object& values);
private:
    static void get_packageInfo(duer::Object& obj);
    char *m_szTransaction_id;
    int m_current_event;
    rtos::Mutex    m_Lock;
};
