/**
 * File: baidu_iot_ota_manager.h
 * Auth: Duan Lian(duanlian01@baidu.com)
 * Date: 2016.12.21
 * Desc: The OTA Manager
 */
#pragma once
#include "rtos.h"
#include "shared_buffer.h"
#include "baidu_iot_ota_reporter.h"
//#include "baidu_iot_ota_package_scanner.h"  //k64f
#ifdef TARGET_UNO_91H
#include "package_scanner.h"     //rda
#endif
#define OPTIONAL_UPDATE 0
#define MANDATED_UPDATE  1


struct OTAServerUpdateCommand
{
	  char transaction[65];
	  char version[16];
	  char old_version[16];
	  char url[129];
	  char signature[129];
	  unsigned int size;
};

class OTAManager
{
public:
    static OTAManager* instance();
	  ~OTAManager();
	  int checkUpdates(const char *command = 0);
    int syncPackageInfo();

    int getOSInfo(os_info_t& info);
private:
	  enum {SHARED_BUFFER_SIZE = 2048};
		SharedBuffer m_SharedBuffer;
    static OTAManager _manager;
    bool           m_bIdle;
		char          *m_pUpdateCommand;
		OTAReporter   *m_pReporter;
    rtos::Thread  *m_pThread;
    rtos::Thread  *m_pRestart_thread;
    rtos::Mutex    m_Lock;
		rtos::Semaphore *m_pInstallComplete;
		#ifdef TARGET_UNO_91H
		PackageScanner m_Scanner;
		#endif

    OTAManager();
		//check if updates are available and perform downloading
    void run_downloader();
		int contact_ota_server();
		int parse_update_command(const char* str_command, OTAServerUpdateCommand &command);
		//decrypt package and write data to storage
    void run_installer();
    int applyUpdates(const OTAServerUpdateCommand& command);
		static int data_available(unsigned char* data, unsigned int len, void* ctx);
        static void ota_resart();
};
