#ifndef __MEASURETIME_H__
#define __MEASURETIME_H__

#include <string>
#include <map>
#include <stdio.h>

#define print_error printf

int time_current_get(void);

namespace baidu{
namespace os{

typedef struct __MeasureValue{
	unsigned int total_cnt;
	unsigned int cur_cnt;
	unsigned int time_begin;
	unsigned int time_sum;
	unsigned int time_min;
	unsigned int time_max;
	unsigned int arg_value;
}MeasureValue;

typedef struct __ListNode{
	__ListNode *next;
	//char* Key;
	std::string Key;
	MeasureValue Value;
}ListNode;

typedef int (*TimeFuncPtr)(void);

// this class is not thread-safe
class MeasureTimeList{
public:
	static MeasureTimeList* getInstMeasureTime(TimeFuncPtr time_func);
	//void addMeasureValue(const char* key, int count, int arg_value);
	void addMeasureValue(const char* key, unsigned int count = 0xffffffff);
	//void updateMeasureValue(const char* key);
	void updateMeasureValue(const char* key, unsigned arg_value = 0);
	void outputResult();
	void destoryMeasureValueList();

private:
	MeasureTimeList(TimeFuncPtr time_func);
	MeasureTimeList(const MeasureTimeList&);
	MeasureTimeList& operator=(const MeasureTimeList&);
	bool searchMeasureValueByKey(const char* key, ListNode* &temp);
	
private:
	static MeasureTimeList* _instance;
	static TimeFuncPtr _time_func;
	ListNode* _pListHead;
	ListNode* _pListTail;
//	map<const char *, MeasureValue> _map_value;
};
} //namespace os
} //namespace baidu
#endif //~__MEASURETIME_H__
