#pragma once
#include "../iot-baidu-ca/source/baidu_ca_coap.h"
#include "../iot-baidu-ca/include/baidu_ca.h"
#include "../iot-baidu-ca-adapter/baidu_ca_network_socket.h"
class CoapsClient
{
public:
    CoapsClient(const char* ip, unsigned short port,
			          const char* path, const char* cert);
    ~CoapsClient();
		int connect();
    int get(unsigned int nOffset, unsigned char chBuffer[], unsigned int nSize);
		int disconnect();
private:
	  void network_signal_handler(const bca_addr_t *addr);
    bca_coap_handler m_coapInstance;
    bool m_bConnected;
    bca_addr_t  m_peer;
    const char* m_szPath;
    const char* m_szCert;
    duer::SocketAdapter::Callback  _on_network_data_signal;

};
