/*
 * NewFirmwareImageUnpackTool.h
 *
 *  Created on: 2016-7-12
 *      Author: duanlian01
 */

#ifndef NEWFIRMWAREIMAGEUNPACKTOOL_H_
#define NEWFIRMWAREIMAGEUNPACKTOOL_H_
#include "IOtaUpdater.h"

class OTAReporter;

class NewFirmwareImageUnpackTool {
public:
	NewFirmwareImageUnpackTool(unsigned int decompress_chunk_size, unsigned int resource_size, IOtaUpdater *updater, void *update_cxt, OTAReporter *reporter);
	virtual ~NewFirmwareImageUnpackTool();
	virtual int unpack_ota_package_begin();
	virtual int unpack_ota_package(unsigned char* data, unsigned int len);
  virtual int unpack_ota_package_end();

  virtual int update_image_begin();
	virtual int update_image();
  virtual int update_image_end();

private:
	unsigned int resource_size;
  unsigned int resource_offset;
  double download_percent;
	unsigned int chunk_size;
	unsigned char *cache;
	unsigned int  in_size;

	void* verification_cxt;
  void* decompress_ctx;

  IOtaUpdater *updater;
  void *update_cxt;

  OTAReporter *m_pReporter;
};

#endif /* NEWFIRMWAREIMAGEUNPACKTOOL_H_ */
