#pragma once
#include "rtos.h"

class SharedBuffer
{
public:
    SharedBuffer(unsigned int size);
    ~SharedBuffer();
    unsigned int read(unsigned char out[], unsigned int size);
    unsigned int write(const unsigned char in[], unsigned int size);
    void wait();
private:
	  unsigned int m_nBufferSize;
    unsigned int m_nWriteOffset;
    unsigned int m_nDataSize;
    unsigned char *m_pBuffer;
    rtos::Semaphore sem_Read;
    rtos::Semaphore sem_Write;
};
