// Copyright 2017 Baidu Inc. All Rights Reserved.
// Author: Pan Haijun, Gang Chen(chengang12@baidu.com)
//
// This header file define the HttpClient class, it's used to establish http connection.

#ifndef BAIDU_IOT_TINYDU_IOT_OS_SRC_HTTP_CLIENT_BAIDU_HTTP_CLIENT_H
#define BAIDU_IOT_TINYDU_IOT_OS_SRC_HTTP_CLIENT_BAIDU_HTTP_CLIENT_H

#include "baidu_http_client_c.h"

namespace duer {

class HttpClient {
public:
    HttpClient();
    ~HttpClient();
    /*
     *  register data output handler callback to handle data block
     *  @param[in] data output handler callback to be registered
     *  @param[in] p_usr_ctx for data output handler callback to be registered
     *  @return   none
     */
    void register_data_handler(data_out_handler_cb data_hdlr_cb, void* p_usr_ctx);
    /*
     *  register callback for stop notify & reset stop notify
     *  @param[in] chk_stp_cb: to notify httpclient to stop
     *  @param[in] rst_stp_cb: to reset stop notify flag
     *  @return   none
     */
    void register_notify_call_back(check_stop_notify_cb_t chk_stp_cb,
                                   reset_stop_notify_cb_t rst_stp_cb);
    /*
     *  create http connection and get data by the url
     *  @param[in] url: to get http client_c's url
     *  @return   e_http_result
     */
    e_http_result get(const char* url);
    /*
     *  register callback to get url which is used by http to get data
     *  @param[in] the callback to be registered
     *  @return   none
     */
    void register_call_back_to_get_url(get_url_cb_t cb);
private:
    http_client_c* _p_client_inst;
};

}//duer
#endif//BAIDU_IOT_TINYDU_IOT_OS_SRC_HTTP_CLIENT_BAIDU_HTTP_CLIENT_H

