#ifndef __BAIDU_TIME_CALCULATE_H__
#define __BAIDU_TIME_CALCULATE_H__

#ifdef __cplusplus
extern "C" {
#endif

void add_measure_value(int key, int count);
void update_measure_value(int key, int arg_value, int continuous_measure_flag);
void output_measure_result();

//**************************************************************************************//
//	KEY is number from 0 to 9, because the macor ArraySize is 10. You can enlarge it if you calcute more than 10 sites.
//	COUNTER is the biggest measurement times.
//	ARGUEMENT is used for speed as ARGUEMENT/TIME_AVERAGE.
//
//	!!!!!! Take carefull: KEY in TIME_BEGIN and TIME_END must be the same. !!!!!!
//
//	TIME_BEGIN(1, 10);
//	printf("ABC");
//	TIME_END(1, 200, UNCONTINUOUS_TIME_MEASURE);
//
//	You can call TIME_RESULT() anywhere to print the resutl.
//
//**************************************************************************************//

enum baidu_time_measure_params {
    // TIME_END will measure time no matter there is a one-to-one TIME_BEGIN or not
    CONTINUOUS_TIME_MEASURE = 0,
    // TIME_END will measure time only when there is a one-to-one TIME_BEGIN
    UNCONTINUOUS_TIME_MEASURE = 1,
    MAX_TIME_CALCULATE_COUNT = 0X7FFFFFFF,
};

#define TIME_BEGIN(KEY, COUNTER) do{\
	add_measure_value(KEY, COUNTER);\
}while(0)

#define TIME_END(KEY, ARGUEMENT, FLAG) do{\
	update_measure_value(KEY, ARGUEMENT, FLAG);\
}while(0)

#define TIME_RESULT() do{\
	output_measure_result();\
}while(0)

//#define BAIDU_PERFORM_STATISTIC

enum baidu_perform_statistic_watch_point {
    PERFORM_STATISTIC_START_RECORD = 1,  // from user press start button to start record
    PERFORM_STATISTIC_RECORDER_ON_DATA,  // time consume of encode and send record data
    PERFORM_STATISTIC_READ_VOICE_DATA, // time consume of read voice data from arm
    PERFORM_STATISTIC_SOTP_RECORD, // from user stop record to the recorder thread stop
    PERFORM_STATISTIC_BASE64_ENCODE, // the time consume of mbedtls_base64_encode
    PERFORM_STATISTIC_GET_URL, // the time from user stop record to get media data from URL
    // time consume of recorder_output_handler(encode and pass to CA)
    PERFORM_STATISTIC_OUTPUT_RECORDER_DATA,
    // time consume of bdspx_speex_encode encode data(exclude output encoded data)
    PERFORM_STATISTIC_SPEEX_ENCODE,
    PERFORM_STATISTIC_GET_MEDIA_BY_URL, // time consume from get media data from url to play it
    PERFORM_STATISTIC_PLAY_URL_MEDIA, // time consume of mdm_media_data_out_handler(play url data)
    PERFORM_STATISTIC_GET_MEDIA_BY_PATH, // time consume of read local media
    PERFORM_STATISTIC_PLAY_LOCAL_MEDIA, // time consume of mdm_media_data_out_handler(play local data)
};

#ifdef BAIDU_PERFORM_STATISTIC
#define PERFORM_STATISTIC_BEGIN(KEY, COUNTER) TIME_BEGIN(KEY, COUNTER)
#define PERFORM_STATISTIC_END(KEY, ARGUEMENT, FLAG) TIME_END(KEY, ARGUEMENT, FLAG)
#define PERFORM_STATISTIC_RESULT() TIME_RESULT()
#else
#define PERFORM_STATISTIC_BEGIN(KEY, COUNTER)
#define PERFORM_STATISTIC_END(KEY, ARGUEMENT, FLAG)
#define PERFORM_STATISTIC_RESULT()
#endif

#ifdef __cplusplus
}
#endif

#endif //~__BAIDU_TIME_CALCULATE_H__
