#ifndef __MEASURETIME_H__
#define __MEASURETIME_H__
#include "us_ticker_api.h"

#define ArraySize 20

#define print_error printf

namespace baidu{
namespace os{

typedef struct __MeasureValue{
	unsigned int total_cnt;
	unsigned int cur_cnt;
	unsigned int time_begin;
	unsigned int time_sum;
	unsigned int time_min;
	unsigned int time_max;
	unsigned int arg_value;
}MeasureValue;

typedef unsigned int (*TimeFuncPtr)(void);

// this class is not thread-safe
class MeasureTime{
public:
	static MeasureTime* getInstMeasureTime(TimeFuncPtr time_func);
	void addMeasureValue(int key, int count);
	void updateMeasureValue(int key, int arg_value, int continuous_measure_flag);
	void outputResult();

private:
	MeasureTime(TimeFuncPtr time_func);
	MeasureTime(const MeasureTime&);
	MeasureTime& operator=(const MeasureTime&);
	
private:
	static MeasureTime* _instance;
	static TimeFuncPtr _time_func;
	MeasureValue MeasureArray[ArraySize];
};

} //namespace os
} //namespace baidu
#endif //~__MEASURETIME_H__
