// Copyright (2016) Baidu Inc. All rights reserved.
/**
 * File: main.cpp
 * Desc: Sample code for startup DuerOS
 */

#include "mbed.h"
#include "baidu_media_manager.h"
#include "duer_app.h"
#include "events.h"
#include "duer_log.h"
#if defined(TARGET_UNO_91H)
#include "SDMMCFileSystem.h"
#include "WiFiStackInterface.h"
#include "factory_test.h"
#include "gpadckey.h"
#ifdef RDA_SMART_CONFIG
#include "rda5981_smartconfig.h"
#endif // RDA_SMART_CONFIG
#elif defined(TARGET_K64F)
#include "SDFileSystem.h"
#include "EthernetInterface.h"
#else
#error "Not supported"
#endif // TARGET_UNO_91H

#if defined(TARGET_UNO_91H)

// TODO: Configure your AP
#ifndef CUSTOM_SSID
#define CUSTOM_SSID         ("TP-LINK_69DA")
#endif // CUSTOM_SSID

#ifndef CUSTOM_PASSWD
#define CUSTOM_PASSWD       ("qwertyuiop")
#endif // CUSTOM_PASSWD

GpadcKey key_up(KEY_A3);
GpadcKey key_down(KEY_A4);

// Initialize SD card
SDMMCFileSystem g_sd(GPIO_PIN9, GPIO_PIN0, GPIO_PIN3, GPIO_PIN7, GPIO_PIN12, GPIO_PIN13, "sd");

static WiFiStackInterface s_net_stack;
#else
SDFileSystem g_sd = SDFileSystem(D11, D12, D13, D10, "sd");
static EthernetInterface s_net_stack;
#endif // TARGET_UNO_91H

static unsigned char s_volume = 8;

void* baidu_get_netstack_instance(void) {
    return (void*)&s_net_stack;
}

void voice_up() {
    if (s_volume < 15) {
        duer::MediaManager::instance().set_volume(++s_volume);
    }
}

void voice_down() {
    if (s_volume > 0) {
        duer::MediaManager::instance().set_volume(--s_volume);
    }
}

// main() runs in its own thread in the OS
int main() {
#if defined(TARGET_UNO_91H)
    // Initialize RDA FLASH
    const unsigned int RDA_FLASH_SIZE     = 0x400000;   // Flash Size
    const unsigned int RDA_SYS_DATA_ADDR  = 0x18204000; // System Data Area, fixed size 4KB
    const unsigned int RDA_USER_DATA_ADDR = 0x18205000; // User Data Area start address
    const unsigned int RDA_USER_DATA_LENG = 0x3000;     // User Data Area Length

    rda5981_set_flash_size(RDA_FLASH_SIZE);
    rda5981_set_user_data_addr(RDA_SYS_DATA_ADDR, RDA_USER_DATA_ADDR, RDA_USER_DATA_LENG);

    // Test added by RDA
    factory_test();
#endif

    DUER_LOGI("\nEntry Tinydu Main>>>>\n");

    duer::MediaManager::instance().initialize();

#if defined(TARGET_UNO_91H)
    key_up.fall(&voice_up);
    key_down.fall(&voice_down);
#endif

    // Brings up the network interface
#ifdef RDA_SMART_CONFIG
    typedef void (*dummy_func)();
    mbed::GpadcKey key_erase = mbed::GpadcKey(KEY_A2);
    key_erase.fall((dummy_func)rda5981_flash_erase_smartconfig_data);

    if (s_net_stack.connect(NULL, NULL, NSAPI_SECURITY_NONE) == 0) {
#elif defined(TARGET_UNO_91H)
    if (s_net_stack.connect(CUSTOM_SSID, CUSTOM_PASSWD, NSAPI_SECURITY_NONE) == 0) {
#else
    if (s_net_stack.connect() == 0) {
#endif // RDA_SMART_CONFIG
        const char* ip = s_net_stack.get_ip_address();
        const char* mac = s_net_stack.get_mac_address();
        DUER_LOGI("IP address is: %s", ip ? ip : "No IP");
        DUER_LOGI("MAC address is: %s", mac ? mac : "No MAC");
    } else {
        DUER_LOGE("Network initial failed....");
        Thread::wait(osWaitForever);
    }

    duer::SocketAdapter::set_network_interface(&s_net_stack);

    duer::MediaManager::instance().set_volume(s_volume);

    duer::DuerApp app;
    app.start();

    duer::event_loop();
}
