#include "mbed.h"
#include "CC1101.h"
#include "RingBuffer.h"
 
///////////////////////////////////////////////////
Ticker timer;
CC1101 cc1101(p5, p6, p7, p8, p10);
DigitalIn gdo0(p9);     // pin connected to gdo0 pin of CC1101 for checking that received a new packet

DigitalOut led1(LED1);  // timer blink led
DigitalOut led2(LED2);  // RX led
DigitalOut led3(LED3);  // TX led
Serial pc(USBTX, USBRX); // tx, rx
RingBuffer pcRX(512);   // ring buffer for the pc RX data
RingBuffer pcTX(512);   // ring buffer for the pc TX data
Timeout pcRXtimeout;
Timeout led2timeout;
Timeout led3timeout;
unsigned char buffer[128];
///////////////////////////////////////////////////
void led2timeout_func()
{
    led2 = 0;
    led2timeout.detach();
}
///////////////////////////////////////////////////
void led3timeout_func()
{
    led3 = 0;
    led3timeout.detach();
}
///////////////////////////////////////////////////
void pcRXtimeout_func()         // function for transmiting the RF packets - empty the pcRX ring buffer
{
    unsigned char txlength;
    
    txlength = 0;
    while(pcRX.use() > 0)
    {
      led2 = 1;
      buffer[txlength] = pcRX.getc();
      txlength++;
      led2timeout.attach(&led2timeout_func, 0.050);  // for switch off the led
    }
    if (txlength)
      cc1101.SendPacket(buffer, txlength);    // tx packet
    
    pcRXtimeout.detach();
}
///////////////////////////////////////////////////
void timer_func()           // check the status of the CC1101 every 100ms
{    
    unsigned char chip_status_rx, chip_status_tx;
    
    led1 = !led1;
    chip_status_rx = cc1101.ReadChipStatusRX();  // check the rx status 
    if ((chip_status_rx & CHIP_STATE_MASK) == CHIP_STATE_RXFIFO_OVERFLOW)   // if rx overflow flush the rx fifo
      cc1101.FlushRX();  
    if ((chip_status_rx & CHIP_STATE_MASK) == CHIP_STATE_IDLE)              // if state is idle go to rx state again
      cc1101.RXMode();  
    chip_status_tx = cc1101.ReadChipStatusTX();  // check the tx sttus
    if ((chip_status_tx & CHIP_STATE_MASK) == CHIP_STATE_TXFIFO_UNDERFLOW)  // if tx underflow flush the tx fifo
      cc1101.FlushTX();
}
///////////////////////////////////////////////////
int main() 
{
    unsigned char rxlength, i;
    
    pcRX.clear();
    pcTX.clear();
    cc1101.init();
    timer.attach(&timer_func, 0.1);
    while(1)
    {
        if(gdo0)      // rx finished and CRC OK read the new packet
        {
            rxlength = sizeof(buffer);
            if (cc1101.ReceivePacket(buffer, &rxlength) == 1)   // read the rx packet
            {
                led3 = 1;
                for (i = 0; i < rxlength; i++)
                    pcTX.putc(buffer[i]);                       // store the packet to the pcTX ring buffer 
                led3timeout.attach(&led3timeout_func, 0.050);   // for switch off the led
            }
        }
        if (pcTX.use() > 0)         // check if we have data to transmit to pc
            pc.putc(pcTX.getc());   // get the data from the ring buffer and transmit it to the pc
        if (pc.readable())          // check if we received new data from the pc
        {
            pcRX.putc(pc.getc());   // put the data to the pcRX buffer and wait until 20ms passed till the last byte before tx the packet in RF
            pcRXtimeout.attach(&pcRXtimeout_func, 0.020);
        }
        if (pcRX.use() > 20)        // if more than 20 bytes received then tx the packet in RF
            pcRXtimeout_func();
    }     
}
///////////////////////////////////////////////////
