#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"
#include "math.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

// Hardware serial port over DAPLink
Serial daplink(P2_1, P2_0);

// Virtual serial port over USB
USBSerial microUSB; 
I2C i2c(P5_7, P6_0);  //sda,scl

const int Write_Addr = 0x90;                            //Write Addres for Ev Kit per data sheet for temperature sensor
const int Read_Addr = 0x91;                             //Last bit set to 1 in order to read (not write)
const int Temperature_Register_Addr = 0x00;             //Address of Register holding Temperature data
char Configuration_Register_Addr[1];           //Address of Register holding Configuration Settings
char Configuration_Sleep_Data[1];                 //Initialize Sensor into Sleep mode
char Configuration_OneShot_Data[1];                  //Send signal for temperature reading, and then device goes back to sleep

int main()
{
microUSB.printf("=================STARTING=================\r\n");


char data[1];          //Hold Hexidecimal Value
char bdata [15];        //Hold Binary Value
microUSB.printf("Program beginingin now\r\n");

Configuration_Register_Addr[0] = 0x01;
Configuration_Register_Addr[1] = 0x00;

Configuration_Sleep_Data[0] = 0x01;
Configuration_Sleep_Data[1] = 0x01;

Configuration_OneShot_Data[0] = 0x01;
Configuration_OneShot_Data[1] = 0x81;

i2c.write(Write_Addr, Configuration_Sleep_Data , 2, false);                    //Set into Sleep Mode
   
   
    while(1){
        microUSB.printf("Reading initialzing\r\n");

        i2c.write(Write_Addr, Configuration_OneShot_Data , 2, false);                    //Set into Sleep Mode
        wait_ms(1);
        
        i2c.write(Write_Addr, Temperature_Register_Addr , 1, true);                          //Send Address to begin communication, but leave true so we can 
        i2c.read(Read_Addr, data, 2, false);                               //Read the 2 bytes of temperature info collected by the sensor
            //for (int i = 0; i<2;i++){
            //    microUSB.printf("%d   ",data[i]);                //Confirm values are being read from sensor via I2C            
            //}
            //microUSB.printf("\r\n");                                                     
        int count =15;                                              //Loading bits from most significant to least
        microUSB.printf("Starting Temperature Caluclation\r\n");
        for (int k = 0; k<2;k++){                                   //Go through both bytes
        //microUSB.printf("Converting %d from decimal to binary \r\n",data[k]);
            for (int j = 7;j>=0;j--){
                int r = data[k]>>j;                                 //Check all 8 bits
                if(r&1)                                             //Binary 1
                     bdata[count] = 1;                              //Load 1 into array
                else                                                //Binary 0
                     bdata[count] = 0;                              //Load 0 into array
                count --;                                           //Move to next array position
            }
        }
        double temp = 0;
        int index = 14;
        for (float z=6;z>=-8;z--){                                  //Calculate temperature from array holding binary value
            float factor = pow (2,z);                               //Calculate Added Temperature for each bit (Per data sheet)
            temp += bdata[index] * factor;                          //Combine all bit temperature to aquire total sum
            index--;
        }
        microUSB.printf("Temperature is %f degrees Celcius\r\n", temp);
        float fahrenheit = (((temp*9)/5) + 32);                                         //Calculate temperature in F
        microUSB.printf("Temperature is %f degrees fahrenheit\r\n", fahrenheit);
        microUSB.printf("Reading Complete\r\n");
        microUSB.printf("\r\n\n\n\n\n\n");
        wait(5);                                                   //Sensor measures every 10 seconds
    }
}