/*
Simple revolution counter, works stable for 1 - 50000 rpm's
Uses 1 pulse/revolution at pin 10
*/
#include "mbed.h"
#include "TextLCD.h"
#include "IOMacros.h"

Ticker timer;
Timer t;
DigitalOut led(LED1);
volatile float count,oldcount, revf;
int rev;

TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD16x1);


// Function prototype/forward declaration for ISR.
void atint();

/** EINT3_IRQHandler
 */
extern "C" void EINT3_IRQHandler (void) {

    // The "event" is connected to pin p10 which is LPC1768 P0_1
    // so lets trap that and ignore all other GPIO interrupts.
    // Test for IRQ on Port0.
    if (LPC_GPIOINT->IntStatus & 0x1) {
        // If P0_1/p10 rises, call atint()
        if (LPC_GPIOINT->IO0IntStatR & (1 << 1))  atint();
    }

    // Clear this and all other possible GPIO generated interrupts as they don't concern us.
    LPC_GPIOINT->IO2IntClr = (LPC_GPIOINT->IO2IntStatR | LPC_GPIOINT->IO2IntStatF);
    LPC_GPIOINT->IO0IntClr = (LPC_GPIOINT->IO0IntStatR | LPC_GPIOINT->IO0IntStatF);
}

void event_irq_init(void) {
    // Use macro to set p10 as an input.
    p10_AS_INPUT;
    // Enable P0_1/p10 for rising edge interrupt generation.
    LPC_GPIOINT->IO0IntEnR |= (1UL << 1);
    // Enable the interrupt.
    NVIC_EnableIRQ(EINT3_IRQn);
}

void atint() {
    count = t.read();
    t.reset();
}

void attim() {
    LED1_TOGGLE; // Use macro instead of led =!led;
    if (count!=oldcount) {
        oldcount = count;
        rev= (60/count);
            if (rev >= 15000) // Reduce resolution to 100 rpm
                rev = (rev/100)*100;
            else if (rev >= 1000) // Reduce resolution to 10 rpm
                rev = (rev/10)*10;
        lcd.cls();
        lcd.printf("U/m %5d ",rev);
    }
}

int main() {
    count = 0;
    lcd.printf("Revolution counter",rev);
    wait(0.5);
    lcd.cls();
    timer.attach(&attim,1);
    event_irq_init();
    t.start();
    while (1) {
    }
}