#include "akmanalogsensor.h"

#define SCALING_CONSTANT_3V     0.5997202865
#define SCALING_CONSTANT_5V     0.3603082852
#define WAIT_ADC_MS 1

AkmAnalogSensor::AkmAnalogSensor() : AkmSensor(){
    ain = NULL;
}


AkmAnalogSensor::~AkmAnalogSensor(){
    if(ain) delete ain;
}


AkmSensor::Status AkmAnalogSensor::init(const uint8_t p_id, const uint8_t s_id){
    
    VERBOSE("#AkmAnalogSensor init()\r\n");
    
    primaryId = p_id;
    subId = s_id;
    
    if(primaryId == AKM_PRIMARY_ID_LINEAR_SENSOR && subId == AkmAnalogSensor::SUB_ID_EQ430L)             sensorName = "EQ-430L";
    else if(primaryId == AKM_PRIMARY_ID_LINEAR_SENSOR && subId == AkmAnalogSensor::SUB_ID_EQ431L)        sensorName = "EQ-431L";
    else if(primaryId == AKM_PRIMARY_ID_LINEAR_SENSOR && subId == AkmAnalogSensor::SUB_ID_EQ432L)        sensorName = "EQ-432L";
    else if(primaryId == AKM_PRIMARY_ID_LINEAR_SENSOR && subId == AkmAnalogSensor::SUB_ID_EQ433L)        sensorName = "EQ-433L";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_3V && subId == AkmAnalogSensor::SUB_ID_CQ3200)    sensorName = "CQ-3200";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_3V && subId == AkmAnalogSensor::SUB_ID_CQ3201)    sensorName = "CQ-3201";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_3V && subId == AkmAnalogSensor::SUB_ID_CQ3202)    sensorName = "CQ-3202";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_3V && subId == AkmAnalogSensor::SUB_ID_CQ3203)    sensorName = "CQ-3203";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_3V && subId == AkmAnalogSensor::SUB_ID_CQ3204)    sensorName = "CQ-3204";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_3V && subId == AkmAnalogSensor::SUB_ID_CQ320A)    sensorName = "CQ-320A";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_3V && subId == AkmAnalogSensor::SUB_ID_CQ320B)    sensorName = "CQ-320B";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V && subId == AkmAnalogSensor::SUB_ID_CQ3300)    sensorName = "CQ-3300";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V && subId == AkmAnalogSensor::SUB_ID_CQ3301)    sensorName = "CQ-3301";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V && subId == AkmAnalogSensor::SUB_ID_CQ3302)    sensorName = "CQ-3302";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V && subId == AkmAnalogSensor::SUB_ID_CQ3303)    sensorName = "CQ-3303";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V && subId == AkmAnalogSensor::SUB_ID_CQ330A)    sensorName = "CQ-330A";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V && subId == AkmAnalogSensor::SUB_ID_CQ330B)    sensorName = "CQ-330B";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V && subId == AkmAnalogSensor::SUB_ID_CQ330E)    sensorName = "CQ-330E";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V && subId == AkmAnalogSensor::SUB_ID_CQ330F)    sensorName = "CQ-330F";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V && subId == AkmAnalogSensor::SUB_ID_CQ330G)    sensorName = "CQ-330G";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V && subId == AkmAnalogSensor::SUB_ID_CQ330H)    sensorName = "CQ-330H";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V && subId == AkmAnalogSensor::SUB_ID_CQ330J)    sensorName = "CQ-330J";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V && subId == AkmAnalogSensor::SUB_ID_CZ3813)    sensorName = "CZ-3813";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V && subId == AkmAnalogSensor::SUB_ID_CZ3814)    sensorName = "CZ-3814";
    else if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V && subId == AkmAnalogSensor::SUB_ID_CZ3815)    sensorName = "CZ-3815";
    else if(primaryId == AKM_PRIMARY_ID_MISC_ANALOG && subId == AkmAnalogSensor::SUB_ID_EM3242)          sensorName = "EM3242";
    else if(primaryId == AKM_PRIMARY_ID_MISC_ANALOG && subId == AkmAnalogSensor::SUB_ID_AK9710)          sensorName = "AK9710";
    else return AkmSensor::ERROR;
    
    if( ((primaryId == AKM_PRIMARY_ID_MISC_ANALOG) && (subId <= AKM_PRIMARY_ID_CURRENT_SENSOR_3V))
       || primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_3V){
        
        ain = new AnalogIn(ANALOG_IN_A0);
        VERBOSE("#ADC Connected to 3V Channel\r\n");
    }
    else {
        ain = new AnalogIn(ANALOG_IN_A0);;
        VERBOSE("#ADC Connected to 5V Channel\r\n");
    }
    
    interval = SENSOR_SAMPLING_RATE; // 10Hz

    return AkmSensor::SUCCESS;
}

AkmSensor::Status AkmAnalogSensor::startSensor(){
    ticker.attach(callback(this, &AkmSensor::setEvent), interval);
    MSG("#Start sensor: %s.\r\n",sensorName);
    return AkmSensor::SUCCESS;
}

AkmSensor::Status AkmAnalogSensor::startSensor(const float sec){
    interval = sec;
    ticker.attach(callback(this, &AkmSensor::setEvent), interval);
    MSG("#Start sensor %s. Interval = %.2f\r\n", sensorName, interval);
    return AkmSensor::SUCCESS;
}

AkmSensor::Status AkmAnalogSensor::stopSensor(){
    ticker.detach();
    MSG("#Stop sensor %s.\r\n", sensorName);
    return AkmSensor::SUCCESS;
}

AkmSensor::Status AkmAnalogSensor::readSensorData(Message* msg){
    
    uint16_t ain16 = 0;
    int16_t ain16_sign = 0;
    double ain_norm = 0;
    double ain_scl = 0;
    
    VERBOSE("#AkmAnalogSensor: Reading sensor data\r\n");
    AkmSensor::clearEvent();
    
    msg->setCommand(Message::CMD_START_MEASUREMENT);

    if(primaryId == AKM_PRIMARY_ID_LINEAR_SENSOR || primaryId == AKM_PRIMARY_ID_MISC_ANALOG || 
       primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_3V || primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V )
    {       
        // Sample the ADC
        ain_norm = ain->read();
        ain_norm *= 1.97;

        if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_3V){
            ain_scl = ain_norm * 1.8 / SCALING_CONSTANT_3V;
            VERBOSE("#3V scale = %.4f\r\n", ain_scl);
        }
        if(primaryId == AKM_PRIMARY_ID_CURRENT_SENSOR_5V){
            ain_scl = ain_norm * 1.8 / SCALING_CONSTANT_5V;
            VERBOSE("#5V scale = %.4f\r\n", ain_scl);
        }

        ain16 = (uint16_t)(65535 * ain_norm);
        
        //ain16_sign = (int16_t)ain16;
        //ain16_sign = (int16_t)ain16 - 32768;
        ain16_sign = (int16_t)ain_norm*48011.0 - 32768;
        
        VERBOSE("#ain_norm = %.4f\r\n", ain_norm);
        VERBOSE("#ain16 = %d\r\n", ain16);  
        VERBOSE("#ain16_sign = %d\r\n", ain16_sign);
        
        msg->setArgument(0, (char)((ain16_sign & 0xFF00) >> 8));
        msg->setArgument(1, (char)(ain16_sign & 0x00FF));    
    }
    else{
        msg->setArgument(0, 0);
        msg->setArgument(1, 0);
        MSG("readSensorData Error\r\n");
        return AkmSensor::ERROR;
    }
    return AkmSensor::SUCCESS;
}

AkmSensor::Status AkmAnalogSensor::requestCommand(Message* in, Message* out){
    VERBOSE("#AkmAnalogSensor: requestCommand error\r\n");
    return AkmSensor::ERROR;
}
