#include "mbed.h"
#include "string.h"
using namespace std;
 
Serial pc(USBTX, USBRX); // tx, rx
 
InterruptIn service_bryter(p10);
DigitalOut g1(p12);
DigitalOut led_alarm[] = {p21, p22, p23, p24, p25, p26, p27, p28};
AnalogIn sloyfe_alarm[] = {p15, p16, p17, p18};
int alarm_aktiv[8] = {1, 1, 1, 1, 1, 1, 1, 1};
int alarm_deaktiv[8] = {0, 0, 0, 0, 0, 0, 0, 0};
 
LocalFileSystem local("local");
FILE *fp = fopen("/local/LOGGFIL.txt", "w");
 
void status_total();
void status_enkelt();
void status_alarm();
void start_alarm();
void stopp_alarm();
void nullstill_alarm();
void driftslampe();
void password();
void pc_cmd();
void pc_status_cmd();
void avslutt_logg();
 
Timer tid;
Ticker t1, t2;
 
int main()
/*===========================================
                                                                       
Maine-programmeet som først kjører           
funksjonen passord, deretter nullstiller     
alarmindikatorene.                           
                                             
I while-løkka kan brukeren bestemme          
kommando som skal kjøres.                    
                                             
Program skrevet av Trond 10/2-15             
 
============================================*/
{
    
    
    password();
    tid.start();
    nullstill_alarm();
    
    service_bryter.rise(&nullstill_alarm);
 
    pc.printf("\nTast inn folgende kommandoer og trykk ENTER etter behov:\n");
    pc.printf("\nSTATUS for aa hente inn statusen til alarmanlegget\n");
    pc.printf("RESET for aa nullstille alarmanlegget\n");
    pc.printf("START for aa starte alarmovervaakningen av anlegget\n");
    pc.printf("STOPP for aa stoppe alarmovervaakningen av anlegget\n");
    pc.printf("AVSLUTT for aa avslutte loggforing\n\n");
    fflush(stdout);
    while(1) {
        pc_cmd();
        fflush(stdin);
    }
}
 
 
void status_alarm()
/*==========================================                                             
Lokale variabler: i, j, ain, X, Y, XY.                         
Funksjon som leser av sløyfene.              
Funksjonen registerer hvis en eller flere    
alarminnganger blir aktivert, somt loggfører 
hvilken alarm og tid aktiveringen fant sted. 
                                             
Program skrevet av Trond 10/2-15             
==========================================*/
{
    int i = 0;
    int j;
    float ain;
    float X = (1.65/3.30), Y = (1.00/3.30), XY = (0.75/3.30);
 
    for(j = 0; j <= 3; j++) {
 
        ain = sloyfe_alarm[j];
 
        if( ain >= X && ain < 1.0f) {
            led_alarm[i]  = 1;
        } else if( ain >= Y && ain < X) {
            led_alarm[i + 1] = 1;
        } else if( ain >= XY && ain < Y) {
            led_alarm[i] = led_alarm[i + 1] = 1;
        }
        i = i + 2;
    }
 
    for(i = 0; i <= 7; i++) { 
        if(led_alarm[i] == 1 && alarm_aktiv[i] == 1) {
            fprintf(fp, "Alarm nr %d ble aktivert %.1f sekunder etter oppstart av programmet\n\n", (i+1), tid.read() );
            alarm_aktiv[i] = 0;
        } else if(alarm_deaktiv[i] == 1 && led_alarm[i] == 0) {
            fprintf(fp, "Alarm nr %d ble deaktivert %.1f sekunder etter oppstart av programmet\n\n", (i+1), tid.read() );
        }
        alarm_deaktiv[i] = 0;
    }
}
 
void nullstill_alarm()
/*=============================================
 
Lokal variabel i.                            
Funksjon som nullstiller alarminngangene.    
                                             
Program skrevet av Trond 10/2-15             
 
=============================================*/
{
    int i;
    for(i = 0; i <= 7; i++) {
        if( led_alarm[i] == true ) {
            alarm_deaktiv[i] = true;
        }
        led_alarm[i] = false;
        alarm_aktiv[i] = true;
    }
}
 
void driftslampe()
/*=============================================
                                           
Lokal variabler: i, k                            
Funksjon som sjekker alarminngangene    
holder driftlampa oppdatert.                 
                                             
Program skrevet av Trond 10/2-15   
          
==============================================*/
{
    int i;
    int k = 0;
 
    for( i = 0; i <= 7; i++ ) { 
        if( led_alarm[i] == 1 ) {
            k = 1;
        } 
    }
    
        if( k == 1 ){
            g1 = 1;
            wait(0.1);
            g1 = 0;
            wait(0.1);
        }else {
            g1 = 1;
        }
}
 
void status_total()
/*==============================================
                                          
Lokal variabel i.                            
Funksjon som lar brukeren sjekke totalstatus 
på alarmanlegget.                            
                                             
Program skrevet av Trond 10/2-15
            
==============================================*/
{
    int i;
    for(i = 0; i <= 7; i++) {
        if( led_alarm[i] == 1 ) {
            pc.printf("Alarm nummer %d er aktiv\n", (i + 1) );
        } else {
            pc.printf("Alarm nummer %d er deaktivert\n", (i + 1) );
        }
    }
    pc.printf("\n");
}
 
void status_enkelt()
/*==============================================
                                             
Lokal variabel i.                            
Funksjon som lar brukeren sjekke status på   
en enkelt alarminngang.                      
                                             
Program skrevet av Trond 10/2-15
============================================== */       
{
    int i;

 
    pc.printf("\nTast inn alarm nummeret du vil ha statusen for: ");
    while(1) {
        pc.scanf("%d", &i);
 
/*============================================                                           
Brukeren taster alarminngang                 
if-testen sjekker at inntastningen er        
korrekt.   
=============================================*/

        if( i >= 1 && i <= 8 ) {
            break;
        } else {
            pc.printf("\nUgyldig alarmnummer, prov igjen: ");
        }
    }
 
    if( led_alarm[i - 1] == 1 ) {
        pc.printf("Alarm nummer %d er aktiv\n\n", i);
    } else {
        pc.printf("Alarm nummer %d er deaktivert\n\n", i);
    }
}
 
void password()
/*==============================================  
                                            
Lokal variabel passord.                      
Sikkerhetsfunksjon der brukeren skal taste   
passord for å komme videre i programmet.     
                                            
Program skrevet av Trond 10/2-15             
 
===============================================*/
{
    char passord[20];

 
    pc.printf("Tast inn passordet for aa starte opp programmet: ");
 
    while(1) {
        pc.scanf("%s", passord);
 
        if(strcmp(passord, "hiof") == 0 ) {
            break;
        } else {
            pc.printf("\nFeil passord, prov igjen: ");
        }
    }
    pc.printf("\n");
}
 
void pc_cmd()
/*============================================
                                             
Lokal variabel cmd.                          
Funksjonen lar brukeren velge hvilken       
kommando som skal kjøres.                    
                                                                                       
Program skrevet av Trond 10/2-15             
 
=============================================*/
{
    char cmd[20];
 
    pc.scanf("%s", cmd);
 
    if( strcmp(cmd, "START") == 0 ) {
        start_alarm();
    } else if( strcmp(cmd, "RESET") == 0 ) {
        nullstill_alarm();
    } else if( strcmp(cmd, "STOPP") == 0 ) {
        stopp_alarm();
    } else if( strcmp(cmd, "STATUS") == 0 ) { 
        pc_status_cmd();
    } else if( strcmp(cmd, "AVSLUTT") == 0 ) {
        avslutt_logg();
    } else {
        pc.printf("Ugyldig kommando, prov igjen: \n");
    }
}
 
void pc_status_cmd()
/*==========================================
Lokal variabel cmd.                          
Brukeren kan velge mellom enkelt- eller      
totalstatus på alarminngangene.              
                                             
Etter at brukeren taster komando, kjøres      
funksjonen som gitt i If-testen.             
                                             
Program skrevet av Trond 10/2-15             
 
==========================================*/
{
    char cmd[20];

 
    pc.printf("\n\nTast inn ENKELT eller TOTAL for statusen i anlegget og trykk ENTER\n");
 
    while(1) {
        pc.scanf(" %s", &cmd);
        if( strcmp(cmd, "TOTAL") == 0) {
            status_total();
            break;
        } else if( strcmp(cmd, "ENKELT") == 0 ) {
            status_enkelt();
            break;
        } else {
            pc.printf("Ugyldig kommando, prov igjen: \n");
        }
    }
}
 
void start_alarm()
/*==============================================
                                      
Funksjonen starter programmet.               
Setter igang tickerne som leser av status på 
på sløyfene samt driftlampe.                 
                                             
Program skrevet av Trond 10/2-15 
            
===============================================*/
{
    t1.attach(&status_alarm, 2.0);
    t2.attach(&driftslampe, 0.5);
}
 
void stopp_alarm()
/*============================================
                                            
Funksjonen stopper programmet.               
Detach'er tickerne som leser av status på    
på sløyfene.                                 
                                             
Program skrevet av Trond 10/2-15             
 
============================================*/
{
    t1.detach();
    t2.detach();
    g1 = 0;
}
 
void avslutt_logg()
/*============================================
 
Funksjonen avslutter programmet.             
Henter funksjonen nullstill_alarm            
og avslutter loggfilen samt programmet.      
                                            
Program skrevet av Trond 10/2-15             
 
============================================*/
{
    nullstill_alarm();
    stopp_alarm();
    fclose(fp);
    pc.printf("\n\nLoggforingen av statusendringer i anlegget er naa avsluttet, dersom du oonsker aa starte en ny loggforing maa programmet restartes\n\n");
}