#include "R1370.h"

R1370::R1370(PinName Tx,PinName Rx):serial(Tx,Rx)
{
    R1370::serial.baud(115200);
}
int R1370::update()
{
    int i;
    if((data[0]=serial.getc())==0xAA){
        for(i = 1;i < 15;i++) {
            data[i] = serial.getc();
        }
        angle = ((data[3]&0xFF)|((data[4]<<8)&0xFF00));
        gyro = angle/100.0;
        return 0;
    }else{
        return 1;
    }
}
float R1370::getAngle()
{
    return gyro;
}