/*
 * mbed library to draw graphs to serial console
 * Copyright (c) 2013 Tobias Knapp
 * Released under the MIT License: http://mbed.org/license/mit
 */

#include "Terminal.h"

#ifndef MBED_ASCIIGRAPH_H
#define MBED_ASCIIGRAPH_H

/** Print ASCII graph to serial console using Terminal Lib
 *
 * This allows you to display measuring data at serial console
 */
class ASCIIGraph {

public:
    /** Create a ASCIIGraph object
     *
     * @param terminal Terminal* Pointer to a Terminal instance
     * @param startX int Coordinate to start graph (left 0 -> right positive)
     * @param startY int Coordinate to start graph (top  0 -> down positive)
     * @param width int Width of graph
     * @param height int Height of graph
     * @param labelXoffset int Space between startX and y-axis (for printing labels) [default = 7]
     */
    ASCIIGraph(Terminal * terminal, int startX, int startY, int width, int height, int labelXoffset = 7);
    
    /** Destroys the ASCIIGraph object */
    ~ASCIIGraph();
    
    char getXAxisChar(){ return xAxisChar; };
    /** Set character for printing x-axis */
    void setXAxisChar(char c) { xAxisChar = c; };
    
    char getYAxisChar(){ return yAxisChar; };
    /** Set character for printing y-axis */
    void setYAxisChar(char c){ yAxisChar = c; };
    
    char getZeroChar(){ return zeroChar; };
    /** Set character for printing (0|0)-Point */
    void setZeroChar(char c){ zeroChar = c; };
    
    char getFilledChar(){ return filledChar; };
    /** Set character for printing a filled cell */
    void setFilledChar(char c){ filledChar = c; };
    
    char getPlainChar(){ return plainChar; };
    /** Set character for printing a not filled cell */
    void setPlainChar(char c){ plainChar = c; };
    
    /** Prints the axis initially */
    void initGraph();
    
    /** Add new float value to the graph
     * 
     * @param dataPoint float Value to be added to the graph
     */
    void pushDataPoint(float dataPoint);
    
    /** Draw graph */
    void drawGraph();
    
    /** Reset graph (e.g. Changing messure data source) */
    void reset();

private:
    bool first;
    
    Terminal * term;
    
    float * pData;
    char * pLine;
    
    int START_X;
    int START_Y;
    int WIDTH;
    int HEIGHT;
    int LABEL_X_OFFSET;
    int BASE_X;
    int BASE_Y;
    
    char xAxisChar;
    char zeroChar;
    char yAxisChar;
    char filledChar;
    char plainChar;
};

#endif