#include "mbed.h"

class Logger {
    RawSerial _serial;
public:
    template<class TX, class RX>
    Logger(TX tx, RX rx, long baud = 9600) : _serial(tx, rx, baud) {}
    
    template<class ...Args>
    void log(const char* s, Args... args) {
        _serial.puts(s);
        log(args...);
    }

    template<class ...Args>
    void log(int n, Args... args) {
        // we only support 0..15, no need to divide
        if (n >= 10) {
            _serial.putc('1');
            n -= 10;
        }
        _serial.putc('0' + n);
        log(args...);
    }
    
    void log() {
        _serial.puts("\r\n");
    }
};

Logger pc(SERIAL_TX, SERIAL_RX, 115200);

int main()
{
    pc.log("foo", "bar", 0, 1, 2, 9, 10, 15);
}
